/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.io.Serializable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.builder.ResourceType;
import org.drools.grid.ConnectionFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridConnection;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.SocketService;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.JpaWhitePages;
import org.drools.grid.service.directory.impl.WhitePagesClient;
import org.drools.grid.service.directory.impl.WhitePagesImpl;
import org.drools.io.Resource;
import org.drools.io.impl.ByteArrayResource;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsGridTest {
    @Test
    public void test1() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.grid");
        JpaWhitePages wp = new JpaWhitePages(emf);
        wp.create("s1");
        wp.create("s2");
        wp.create("s3");
    }

    @Test
    public void testGrid() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/grid.xml");
        Grid grid1 = (Grid)context.getBean("grid1");
        Assert.assertTrue((boolean)(grid1.get(WhitePages.class) instanceof JpaWhitePages));
        Grid grid2 = (Grid)context.getBean("grid2");
        Assert.assertTrue((boolean)(grid2.get(WhitePages.class) instanceof WhitePagesClient));
        Grid grid3 = (Grid)context.getBean("grid3");
        Assert.assertTrue((boolean)(grid3.get(WhitePages.class) instanceof WhitePagesImpl));
        GridServiceDescription n1Gsd = ((WhitePages)grid2.get(WhitePages.class)).lookup("node1");
        GridConnection conn = ((ConnectionFactoryService)grid2.get(ConnectionFactoryService.class)).createConnection(n1Gsd);
        GridNode remoteN1 = (GridNode)conn.connect();
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)remoteN1.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        Assert.assertNotNull((Object)kbuilder);
        String rule = "package test\nimport org.drools.container.spring.SpringDroolsGridTest.MyObject;\nglobal MyObject myGlobalObj;\nrule \"test\"  when       $o: MyObject()  then      System.out.println(\"My Global Object -> \"+myGlobalObj.getName());      System.out.println(\"Rule Fired! ->\"+$o.getName()); end";
        kbuilder.add((Resource)new ByteArrayResource(rule.getBytes()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.out.println("Error: " + error.getMessage());
            }
            Assert.fail((String)"KnowledgeBase did not build");
        }
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)remoteN1.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        Assert.assertNotNull((Object)kbase);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Assert.assertNotNull((Object)session);
        session.setGlobal("myGlobalObj", (Object)new MyObject("myGlobalObj"));
        FactHandle handle = session.insert((Object)new MyObject("myObj1"));
        Assert.assertNotNull((Object)handle);
        int fired = session.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        session.retract(handle);
        handle = session.insert((Object)new MyObject("myObj2"));
        session.update(handle, (Object)new MyObject("myObj3"));
        fired = session.fireAllRules();
        remoteN1.dispose();
        ((SocketService)grid1.get(SocketService.class)).close();
    }

    public static class MyObject
    implements Serializable {
        private String name;

        public MyObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

