/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.util.ArrayList;
import java.util.Map;
import org.drools.ClockType;
import org.drools.Person;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.agent.impl.KnowledgeAgentImpl;
import org.drools.common.InternalRuleBase;
import org.drools.conf.EventProcessingOption;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.grid.GridNode;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.io.impl.UrlResource;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.instance.impl.humantask.HumanTaskHandler;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsTest {
    @Test
    public void testNoConnection() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        GridNode node1 = (GridNode)context.getBean("node1");
        Assert.assertNotNull((Object)node1);
        GridNode node2 = (GridNode)context.getBean("node2");
        Assert.assertNotNull((Object)node2);
    }

    @Test
    public void testNoNodeKSessions() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/no-node-beans.xml");
        ArrayList list = new ArrayList();
        StatelessKnowledgeSession kstateless = (StatelessKnowledgeSession)context.getBean("ksession1");
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        StatefulKnowledgeSession kstateful = (StatefulKnowledgeSession)context.getBean("ksession2");
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSimpleKSessions() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        ArrayList list = new ArrayList();
        StatelessKnowledgeSession kstateless = (StatelessKnowledgeSession)context.getBean("ksession1");
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)2L, (long)list.size());
        list = new ArrayList();
        StatefulKnowledgeSession kstateful = (StatefulKnowledgeSession)context.getBean("ksession2");
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testAgents() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/kagents-beans.xml");
        ResourceChangeScannerImpl scanner = (ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService();
        Assert.assertEquals((long)5L, (long)scanner.getInterval());
        KnowledgeBaseImpl kbase1 = (KnowledgeBaseImpl)context.getBean("kbase1");
        KnowledgeBaseImpl kbase2 = (KnowledgeBaseImpl)context.getBean("kbase2");
        KnowledgeAgentImpl kagent1 = (KnowledgeAgentImpl)context.getBean("kagent1");
        Assert.assertSame((Object)kagent1.getKnowledgeBase(), (Object)kbase1);
        Assert.assertEquals((long)0L, (long)kagent1.getResourceDirectories().size());
        Assert.assertFalse((boolean)kagent1.isNewInstance());
        Assert.assertFalse((boolean)kagent1.isUseKBaseClassLoaderForCompiling());
        KnowledgeAgentImpl kagent2 = (KnowledgeAgentImpl)context.getBean("kagent2");
        Assert.assertSame((Object)kagent2.getKnowledgeBase(), (Object)kbase2);
        Assert.assertEquals((long)1L, (long)kagent2.getResourceDirectories().size());
        Assert.assertFalse((boolean)kagent2.isNewInstance());
        Assert.assertFalse((boolean)kagent2.isUseKBaseClassLoaderForCompiling());
        KnowledgeAgentImpl kagent3 = (KnowledgeAgentImpl)context.getBean("kagent3");
        Assert.assertTrue((boolean)kagent3.isNewInstance());
        Assert.assertTrue((boolean)kagent3.isUseKBaseClassLoaderForCompiling());
        StatelessKnowledgeSessionImpl ksession1 = (StatelessKnowledgeSessionImpl)context.getBean("ksession1");
        Assert.assertSame((Object)kbase1.getRuleBase(), (Object)ksession1.getRuleBase());
        Assert.assertSame((Object)kagent1, (Object)ksession1.getKnowledgeAgent());
        StatefulKnowledgeSessionImpl ksession2 = (StatefulKnowledgeSessionImpl)context.getBean("ksession2");
        Assert.assertSame((Object)kbase1.getRuleBase(), (Object)ksession2.getRuleBase());
        StatelessKnowledgeSessionImpl ksession3 = (StatelessKnowledgeSessionImpl)context.getBean("ksession3");
        Assert.assertSame((Object)kagent2, (Object)ksession3.getKnowledgeAgent());
        Assert.assertSame((Object)kbase2.getRuleBase(), (Object)ksession3.getRuleBase());
    }

    @Test
    public void testNode() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        GridNode node = (GridNode)context.getBean("node1");
        ArrayList list = new ArrayList();
        StatelessKnowledgeSession kstateless = (StatelessKnowledgeSession)node.get("stateless1", StatelessKnowledgeSession.class);
        Assert.assertNotNull((String)"can't obtain session named: stateless1", (Object)kstateless);
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)2L, (long)list.size());
        list = new ArrayList();
        StatefulKnowledgeSession kstateful = (StatefulKnowledgeSession)node.get("ksession2", StatefulKnowledgeSession.class);
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testConfiguration() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/session-conf-beans.xml");
        KnowledgeBaseImpl kbase1 = (KnowledgeBaseImpl)context.getBean("kbase1");
        RuleBaseConfiguration rconf = ((InternalRuleBase)kbase1.getRuleBase()).getConfiguration();
        Assert.assertTrue((boolean)rconf.isAdvancedProcessRuleIntegration());
        Assert.assertTrue((boolean)rconf.isMultithreadEvaluation());
        Assert.assertEquals((long)5L, (long)rconf.getMaxThreads());
        Assert.assertEquals((Object)EventProcessingOption.STREAM, (Object)rconf.getEventProcessingMode());
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)rconf.getAssertBehaviour());
        Assert.assertEquals((Object)"org.drools.container.spring.MockConsequenceExceptionHandler", (Object)rconf.getConsequenceExceptionHandler());
        KnowledgeBaseImpl kbase2 = (KnowledgeBaseImpl)context.getBean("kbase2");
        rconf = ((InternalRuleBase)kbase2.getRuleBase()).getConfiguration();
        Assert.assertFalse((boolean)rconf.isAdvancedProcessRuleIntegration());
        Assert.assertFalse((boolean)rconf.isMultithreadEvaluation());
        Assert.assertEquals((long)3L, (long)rconf.getMaxThreads());
        Assert.assertEquals((Object)EventProcessingOption.CLOUD, (Object)rconf.getEventProcessingMode());
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)rconf.getAssertBehaviour());
        StatefulKnowledgeSessionImpl ksession1 = (StatefulKnowledgeSessionImpl)context.getBean("ksession1");
        SessionConfiguration sconf = ksession1.session.getSessionConfiguration();
        Assert.assertTrue((boolean)sconf.isKeepReference());
        Assert.assertEquals((Object)ClockType.REALTIME_CLOCK, (Object)sconf.getClockType());
        Map wih = sconf.getWorkItemHandlers();
        Assert.assertEquals((long)4L, (long)wih.size());
        Assert.assertTrue((boolean)wih.containsKey("wih1"));
        Assert.assertTrue((boolean)wih.containsKey("wih2"));
        Assert.assertTrue((boolean)wih.containsKey("Human Task"));
        Assert.assertTrue((boolean)wih.containsKey("MyWork"));
        Assert.assertNotSame(wih.get("wih1"), wih.get("wih2"));
        Assert.assertEquals(HumanTaskHandler.class, ((WorkItemHandler)wih.get("wih1")).getClass());
        Assert.assertEquals(HumanTaskHandler.class, ((WorkItemHandler)wih.get("wih2")).getClass());
        StatefulKnowledgeSessionImpl ksession2 = (StatefulKnowledgeSessionImpl)context.getBean("ksession2");
        sconf = ksession2.session.getSessionConfiguration();
        Assert.assertFalse((boolean)sconf.isKeepReference());
        Assert.assertEquals((Object)ClockType.PSEUDO_CLOCK, (Object)sconf.getClockType());
    }

    @Test
    public void testResourceAuthenication() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        DroolsResourceAdapter resourceAdapter = (DroolsResourceAdapter)context.getBean("secureResource");
        Assert.assertNotNull((Object)resourceAdapter);
        Resource resource = resourceAdapter.getDroolsResource();
        Assert.assertTrue((boolean)(resource instanceof UrlResource));
        UrlResource ur = (UrlResource)resource;
        Assert.assertEquals((Object)"enabled", (Object)ur.getBasicAuthentication());
        Assert.assertEquals((Object)"someUser", (Object)ur.getUsername());
        Assert.assertEquals((Object)"somePassword", (Object)ur.getPassword());
        resourceAdapter = (DroolsResourceAdapter)context.getBean("insecureResource");
        Assert.assertNotNull((Object)resourceAdapter);
        resource = resourceAdapter.getDroolsResource();
        Assert.assertTrue((boolean)(resource instanceof UrlResource));
        ur = (UrlResource)resource;
        Assert.assertEquals((Object)"disabled", (Object)ur.getBasicAuthentication());
        Assert.assertEquals((Object)"", (Object)ur.getUsername());
        Assert.assertEquals((Object)"", (Object)ur.getPassword());
    }
}

