/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.grid.GridNode;
import org.drools.util.ServiceRegistry;
import org.drools.util.ServiceRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNodeImpl
implements GridNode {
    private String id;
    private final Map<String, Object> localContext = new ConcurrentHashMap<String, Object>();
    private final ServiceRegistry serviceRegistry = ServiceRegistryImpl.getInstance();

    public GridNodeImpl() {
        this.id = UUID.randomUUID().toString();
    }

    public GridNodeImpl(String id) {
        this.id = id;
    }

    @Override
    public <T> T get(String identifier, Class<T> cls) {
        Object service = this.localContext.get(identifier);
        if (service == null) {
            service = this.serviceRegistry.get(cls);
        }
        return (T)service;
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        return this.get(serviceClass.getName(), serviceClass);
    }

    @Override
    public void set(String identifier, Object object) {
        this.localContext.put(identifier, object);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void dispose() {
    }

    public void init(Object context) {
    }
}

