/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.util.ArrayList;
import java.util.List;
import org.drools.Person;
import org.drools.container.spring.MockAgendaEventListener;
import org.drools.container.spring.MockProcessEventListener;
import org.drools.container.spring.MockWorkingMemoryEventListener;
import org.drools.event.rule.DebugWorkingMemoryEventListener;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsListenersTest {
    static ClassPathXmlApplicationContext context = null;
    List<Person> list = new ArrayList<Person>();
    static int counterFromListener = 0;

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/drools/container/spring/listeners.xml");
    }

    @Before
    public void clearGlobalList() {
        this.list.clear();
        counterFromListener = 0;
    }

    public static void incrementValueFromListener() {
        ++counterFromListener;
    }

    public void testStatefulAgendaEventListener() throws Exception {
        StatefulKnowledgeSessionImpl statefulKnowledgeSession = (StatefulKnowledgeSessionImpl)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getAgendaEventListeners().size());
        Assert.assertTrue((boolean)(statefulKnowledgeSession.getAgendaEventListeners().toArray()[0] instanceof MockAgendaEventListener));
    }

    @Test
    public void testStatefulProcessEventListener() throws Exception {
        StatefulKnowledgeSessionImpl statefulKnowledgeSession = (StatefulKnowledgeSessionImpl)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getProcessEventListeners().size());
        Assert.assertTrue((boolean)(statefulKnowledgeSession.getProcessEventListeners().toArray()[0] instanceof MockProcessEventListener));
    }

    @Test
    public void testStatefulWMEventListener() throws Exception {
        StatefulKnowledgeSession statefulKnowledgeSession = (StatefulKnowledgeSession)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getWorkingMemoryEventListeners().size());
        Assert.assertTrue((boolean)(statefulKnowledgeSession.getWorkingMemoryEventListeners().toArray()[0] instanceof MockWorkingMemoryEventListener));
        statefulKnowledgeSession.setGlobal("list", this.list);
        statefulKnowledgeSession.insert((Object)new Person());
        statefulKnowledgeSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessAgendaEventListener() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)statelessKnowledgeSession.getAgendaEventListeners().size());
        Assert.assertTrue((boolean)(statelessKnowledgeSession.getAgendaEventListeners().toArray()[0] instanceof MockAgendaEventListener));
    }

    @Test
    public void testStatelessProcessEventListener() throws Exception {
        StatelessKnowledgeSession kstateless = (StatelessKnowledgeSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)kstateless.getProcessEventListeners().size());
        Assert.assertTrue((boolean)(kstateless.getProcessEventListeners().toArray()[0] instanceof MockProcessEventListener));
    }

    @Test
    public void testStatelessWMEventListener() throws Exception {
        StatelessKnowledgeSession kstateless = (StatelessKnowledgeSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)kstateless.getWorkingMemoryEventListeners().size());
        Assert.assertTrue((boolean)(kstateless.getWorkingMemoryEventListeners().toArray()[0] instanceof MockWorkingMemoryEventListener));
        kstateless.setGlobal("list", this.list);
        kstateless.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithNestedBean() throws Exception {
        StatefulKnowledgeSession statefulKnowledgeSession = (StatefulKnowledgeSession)context.getBean("statefulWithNestedBean");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getWorkingMemoryEventListeners().size());
        statefulKnowledgeSession.setGlobal("list", this.list);
        statefulKnowledgeSession.insert((Object)new Person());
        statefulKnowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithRef() throws Exception {
        StatefulKnowledgeSession statefulKnowledgeSession = (StatefulKnowledgeSession)context.getBean("statefulWithRef");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getWorkingMemoryEventListeners().size());
        statefulKnowledgeSession.setGlobal("list", this.list);
        statefulKnowledgeSession.insert((Object)new Person());
        statefulKnowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithDefault() throws Exception {
        StatefulKnowledgeSession statefulKnowledgeSession = (StatefulKnowledgeSession)context.getBean("statefulWithDefault");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getWorkingMemoryEventListeners().size());
        Assert.assertTrue((boolean)(statefulKnowledgeSession.getWorkingMemoryEventListeners().toArray()[0] instanceof DebugWorkingMemoryEventListener));
    }

    @Test
    public void testStatefulWithGroupedListeners() throws Exception {
        StatefulKnowledgeSession statefulKnowledgeSession = (StatefulKnowledgeSession)context.getBean("statefulWithGroupedListeners");
        Assert.assertEquals((long)1L, (long)statefulKnowledgeSession.getWorkingMemoryEventListeners().size());
        statefulKnowledgeSession.setGlobal("list", this.list);
        statefulKnowledgeSession.insert((Object)new Person());
        statefulKnowledgeSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithNestedBean() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessWithNestedBean");
        Assert.assertEquals((long)1L, (long)statelessKnowledgeSession.getWorkingMemoryEventListeners().size());
        statelessKnowledgeSession.setGlobal("list", this.list);
        statelessKnowledgeSession.execute((Object)new Person());
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithRef() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessWithRef");
        Assert.assertEquals((long)1L, (long)statelessKnowledgeSession.getWorkingMemoryEventListeners().size());
        statelessKnowledgeSession.setGlobal("list", this.list);
        statelessKnowledgeSession.execute((Object)new Person());
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithMultipleSameType() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessWithMultipleSameType");
        Assert.assertEquals((long)2L, (long)statelessKnowledgeSession.getWorkingMemoryEventListeners().size());
        statelessKnowledgeSession.setGlobal("list", this.list);
        statelessKnowledgeSession.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithDefault() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessWithDefault");
        Assert.assertEquals((long)1L, (long)statelessKnowledgeSession.getWorkingMemoryEventListeners().size());
        Assert.assertTrue((boolean)(statelessKnowledgeSession.getWorkingMemoryEventListeners().toArray()[0] instanceof DebugWorkingMemoryEventListener));
    }

    @Test
    public void testStatelessWithGroupedListeners() throws Exception {
        StatelessKnowledgeSession statelessKnowledgeSession = (StatelessKnowledgeSession)context.getBean("statelessWithGroupedListeners");
        Assert.assertEquals((long)1L, (long)statelessKnowledgeSession.getWorkingMemoryEventListeners().size());
        statelessKnowledgeSession.setGlobal("list", this.list);
        statelessKnowledgeSession.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testEventListenersBean() throws Exception {
        Object debugListeners = context.getBean("debugListeners");
        Assert.assertTrue((boolean)(debugListeners instanceof List));
        Assert.assertEquals((long)3L, (long)((List)debugListeners).size());
    }
}

