/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.timer;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.container.spring.timer.TestWorkItemHandler;
import org.drools.persistence.jpa.KnowledgeStoreService;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;

public class MyDroolsBean {
    private static int timerTriggerCount;
    private static int sessionId;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityManagerFactory emf;
    private KnowledgeBase kbase;
    private KnowledgeStoreService kstore;
    private JpaTransactionManager txm;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();

    public void initStartDisposeAndLoadSession() {
        try {
            EntityManager em = this.txm.getEntityManagerFactory().createEntityManager();
            StatefulKnowledgeSession ksession = this.kstore.newStatefulKnowledgeSession(this.kbase, null, this.getEnvironment());
            sessionId = ksession.getId();
            this.logger.info("\n\tSession id: " + sessionId + "\n");
            ksession.getWorkItemManager().registerWorkItemHandler("testWorkItemHandler", (WorkItemHandler)this.workItemHandler);
            ksession.startProcess("timer-flow", null);
            Thread.sleep(4000L);
            ksession.dispose();
        }
        catch (Exception ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    public static synchronized void incrementTimerTriggerCount() {
        ++timerTriggerCount;
    }

    public static synchronized int getTimerTriggerCount() {
        return timerTriggerCount;
    }

    public void endTheProcess() {
        try {
            StatefulKnowledgeSession ksession = this.kstore.loadStatefulKnowledgeSession(sessionId, this.kbase, null, this.getEnvironment());
            this.logger.info("\n\nSleeping to check that the timer is still running");
            Thread.sleep(5000L);
            ksession.getWorkItemManager().completeWorkItem(TestWorkItemHandler.getWorkItem().getId(), null);
            this.logger.info("\n\nSleeping to check that the timer is no longer running");
            Thread.sleep(3000L);
            this.logger.info("Ok");
            ksession.dispose();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    private Environment getEnvironment() {
        Environment environment = KnowledgeBaseFactory.newEnvironment();
        environment.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        environment.set("drools.transaction.TransactionManager", (Object)this.txm);
        environment.set("drools.Globals", (Object)new MapGlobalResolver());
        return environment;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public void setKstore(KnowledgeStoreService kstore) {
        this.kstore = kstore;
    }

    public void setTxm(JpaTransactionManager txm) {
        this.txm = txm;
    }
}

