/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.spring;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Group;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.UserGroupCallbackManager;
import org.jbpm.task.service.test.impl.TestServerUtil;
import org.jbpm.task.service.test.impl.TestTaskServer;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/spring/test-context.xml"})
public abstract class BaseSpringTest {
    protected static Logger logger;
    @Autowired
    protected TaskService taskService;
    protected TaskServiceSession taskSession;
    protected TaskServer server;
    protected TaskClient client;
    protected Map<String, User> users;
    protected Map<String, Group> groups;

    @BeforeClass
    public static void beforeClass() {
        BaseSpringTest.removeAllTasks();
    }

    @Before
    public void setUp() throws Exception {
        logger = LoggerFactory.getLogger(this.getClass());
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        this.users = BaseTest.fillUsersOrGroups((String)"LoadUsers.mvel");
        this.groups = BaseTest.fillUsersOrGroups((String)"LoadGroups.mvel");
        this.taskService.addUsersAndGroups(this.users, this.groups);
        UserGroupCallbackManager.getInstance().setCallback(null);
        this.server = TestServerUtil.startServer((TaskService)this.taskService);
        this.client = new TaskClient(TestServerUtil.createTestTaskClientConnector((String)"client 1", (TestTaskServer)((TestTaskServer)this.server)));
        this.client.connect();
        this.taskSession = this.taskService.createSession();
    }

    @After
    public void after() throws Exception {
        this.taskSession.dispose();
        this.client.disconnect();
        this.server.stop();
    }

    public static void removeAllTasks() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        EntityManager em = emf.createEntityManager();
        List taskList = em.createQuery("from Task").getResultList();
        for (Object entity : taskList) {
            em.remove(entity);
        }
    }
}

