/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.container.spring.beans.persistence.JPASingleSessionCommandServiceFactoryTest;
import org.drools.container.spring.beans.persistence.MyEntity;
import org.drools.container.spring.beans.persistence.MyEntityMethods;
import org.drools.container.spring.beans.persistence.MyEntityOnlyFields;
import org.drools.container.spring.beans.persistence.MyVariableSerializable;
import org.drools.container.spring.beans.persistence.TestWorkItemHandler;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jpa.KnowledgeStoreService;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class VariablePersistenceStrategyTest {
    private static final String TMPDIR = System.getProperty("java.io.tmpdir");
    private static final Logger log = LoggerFactory.getLogger(JPASingleSessionCommandServiceFactoryTest.class);
    private static Server h2Server;
    private ClassPathXmlApplicationContext ctx;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        log.info("stoping database");
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @Before
    public void createSpringContext() {
        try {
            log.info("creating spring context");
            PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
            Properties properties = new Properties();
            properties.setProperty("temp.dir", TMPDIR);
            configurer.setProperties(properties);
            this.ctx = new ClassPathXmlApplicationContext();
            this.ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            this.ctx.setConfigLocation("org/drools/container/spring/beans/persistence/beansVarPersistence.xml");
            this.ctx.refresh();
        }
        catch (Exception e) {
            log.error("can't create spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @After
    public void destroySpringContext() {
        log.info("destroy spring context");
        this.ctx.destroy();
    }

    @Test
    public void testTransactionsRollback() throws Exception {
        final ArrayList list = new ArrayList();
        PlatformTransactionManager txManager = (PlatformTransactionManager)this.ctx.getBean("txManager");
        final Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", this.ctx.getBean("myEmf"));
        env.set("drools.transaction.TransactionManager", (Object)txManager);
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        final KnowledgeStoreService kstore = (KnowledgeStoreService)this.ctx.getBean("kstore1");
        final KnowledgeBase kbRollback = (KnowledgeBase)this.ctx.getBean("kbRollback");
        TransactionTemplate txTemplate = new TransactionTemplate(txManager);
        final StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                StatefulKnowledgeSession kNewSession = kstore.newStatefulKnowledgeSession(kbRollback, null, env);
                kNewSession.setGlobal("list", (Object)list);
                kNewSession.insert((Object)1);
                kNewSession.insert((Object)2);
                return kNewSession;
            }
        });
        int sessionId = ksession.getId();
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)3);
                status.setRollbackOnly();
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)2L, (long)list.size());
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)3);
                ksession.insert((Object)4);
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)5);
                ksession.insert((Object)6);
                status.setRollbackOnly();
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.dispose();
        final StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbRollback, null, (Environment)env);
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession2.setGlobal("list", (Object)list);
                ksession2.insert((Object)7);
                ksession2.insert((Object)8);
                return null;
            }
        });
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession2.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testPersistenceVariables() throws NamingException, NotSupportedException, SystemException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = ((EntityManagerFactory)this.ctx.getBean("myEmf")).createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        em.getTransaction().commit();
        em.close();
        log.info("---> get bean jpaSingleSessionCommandService");
        StatefulKnowledgeSession service = (StatefulKnowledgeSession)this.ctx.getBean("jpaSingleSessionCommandService");
        int sessionId = service.getId();
        log.info("---> created SingleSessionCommandService id: " + sessionId);
        log.info("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)service.startProcess("com.sample.ruleflow", parameters);
        log.info("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        EntityManagerFactory emf = (EntityManagerFactory)this.ctx.getBean("myEmf");
        log.info("### Retrieving process instance ###");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.transaction.TransactionManager", this.ctx.getBean("txManager"));
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KnowledgeStoreService kstore = (KnowledgeStoreService)this.ctx.getBean("kstore1");
        KnowledgeBase kbase1 = (KnowledgeBase)this.ctx.getBean("kbase1");
        service = kstore.loadStatefulKnowledgeSession(sessionId, kbase1, null, env);
        processInstance = (WorkflowProcessInstance)service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        service.dispose();
    }
}

