/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.spring;

import java.util.Map;
import org.h2.tools.Server;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Group;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.identity.UserGroupCallbackManager;
import org.jbpm.task.identity.UserGroupCallbackOneImpl;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.test.impl.TestServerUtil;
import org.jbpm.task.service.test.impl.TestTaskServer;
import org.jbpm.task.service.test.spring.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/spring/test-context.xml"})
public class BaseSpringNoUserGroupSetupTest {
    protected static Logger logger;
    @Autowired
    private TaskService taskService;
    protected TaskServiceSession taskSession;
    protected TaskServer server;
    protected TaskClient client;
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    private static Server dbServer;

    @Before
    public void setUp() throws Exception {
        BaseSpringTest.removeAllTasks();
        logger = LoggerFactory.getLogger(this.getClass());
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        this.users = BaseTest.fillUsersOrGroups((String)"LoadUsers.mvel");
        this.groups = BaseTest.fillUsersOrGroups((String)"LoadGroups.mvel");
        this.taskService.addUsersAndGroups(this.users, this.groups);
        this.server = TestServerUtil.startServer((TaskService)this.taskService);
        this.client = new TaskClient(TestServerUtil.createTestTaskClientConnector((String)"client 1", (TestTaskServer)((TestTaskServer)this.server)));
        this.client.connect();
        this.taskSession = this.taskService.createSession();
        if (!UserGroupCallbackManager.getInstance().existsCallback()) {
            UserGroupCallbackManager.getInstance().setCallback((UserGroupCallback)new UserGroupCallbackOneImpl());
        }
        this.taskSession.addUser(new User("Administrator"));
    }

    @After
    public void after() throws Exception {
        this.taskSession.dispose();
        this.client.disconnect();
        this.server.stop();
    }

    @Test
    public void dummy() {
    }
}

