/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.spring;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.task.Group;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.admin.TasksAdminTest;
import org.jbpm.task.identity.UserGroupCallbackManager;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.test.spring.BaseSpringTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.SystemEventListenerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/spring/test-context.xml"})
public class TasksAdminSpringTest
extends BaseSpringTest {
    protected static Logger logger;
    @Autowired
    protected TaskService taskService;
    protected TaskServiceSession taskSession;
    protected EntityManagerFactory emf;
    private Map<String, User> users = new HashMap<String, User>();
    private Map<String, Group> groups = new HashMap<String, Group>();

    @Before
    public void before() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = this.taskService.createSession();
        TasksAdminTest.addUsersAndGroups((TaskServiceSession)this.taskSession, this.users, this.groups);
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        UserGroupCallbackManager.getInstance().setCallback(null);
    }

    @Test
    public void completedSinceTasksTest() {
        TasksAdminTest.runCompletedSinceTasksTest(this.users, (TaskService)this.taskService);
    }

    @Test
    public void archiveTasksTest() {
        TasksAdminTest.runArchiveTasksTest(this.users, (TaskService)this.taskService, (EntityManagerFactory)this.emf);
    }

    @Test
    public void completedTasksTest() {
        TasksAdminTest.runCompletedTasksTest(this.users, (TaskService)this.taskService);
    }

    @Test
    public void removeTasksTest() {
        TasksAdminTest.runRemoveTasksTest(this.users, (TaskService)this.taskService, (EntityManagerFactory)this.emf);
    }
}

