/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.JpaProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.kie.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DroolsSpringJpaManager
implements ProcessPersistenceContextManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Environment env;
    private EntityManagerFactory emf;
    private EntityManager appScopedEntityManager;
    private boolean internalAppScopedEntityManager;
    private boolean isJTA;

    public DroolsSpringJpaManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("org.kie.persistence.jpa.EntityManagerFactory");
        this.isJTA = true;
        Boolean bool = (Boolean)env.get("IS_JTA_TRANSACTION");
        if (bool != null) {
            this.isJTA = bool;
        }
        this.getApplicationScopedPersistenceContext();
    }

    public PersistenceContext getApplicationScopedPersistenceContext() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("org.kie.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.emf);
                if (emHolder == null) {
                    this.appScopedEntityManager = this.emf.createEntityManager();
                    emHolder = new EntityManagerHolder(this.appScopedEntityManager);
                    TransactionSynchronizationManager.bindResource((Object)this.emf, (Object)emHolder);
                    this.internalAppScopedEntityManager = true;
                } else {
                    this.appScopedEntityManager = emHolder.getEntityManager();
                }
                this.env.set("org.kie.persistence.jpa.AppScopedEntityManager", (Object)emHolder.getEntityManager());
            }
        }
        if (TransactionSynchronizationManager.isActualTransactionActive() && this.isJTA) {
            this.appScopedEntityManager.joinTransaction();
        }
        return new JpaPersistenceContext(this.appScopedEntityManager, this.isJTA);
    }

    public PersistenceContext getCommandScopedPersistenceContext() {
        return new JpaPersistenceContext((EntityManager)this.env.get("org.kie.persistence.jpa.CmdScopedEntityManager"), this.isJTA);
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.persistence.jpa.CmdScopedEntityManager");
        if (cmdScopedEntityManager == null || !cmdScopedEntityManager.isOpen()) {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)"cmdEM");
            EntityManager em = null;
            if (emHolder == null) {
                em = this.emf.createEntityManager();
                emHolder = new EntityManagerHolder(em);
                TransactionSynchronizationManager.bindResource((Object)"cmdEM", (Object)emHolder);
            } else {
                em = emHolder.getEntityManager();
            }
            this.env.set("org.kie.persistence.jpa.CmdScopedEntityManager", (Object)em);
        }
        if (this.isJTA) {
            this.getCommandScopedPersistenceContext().joinTransaction();
            this.appScopedEntityManager.joinTransaction();
        }
    }

    public void endCommandScopedEntityManager() {
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM")) {
            TransactionSynchronizationManager.unbindResource((Object)"cmdEM");
            if (this.env.get("org.kie.persistence.jpa.CmdScopedEntityManager") != null) {
                this.getCommandScopedPersistenceContext().close();
            }
        }
    }

    public void dispose() {
        this.logger.trace("Disposing DroolsSpringJpaManager");
        if (this.internalAppScopedEntityManager) {
            TransactionSynchronizationManager.unbindResource((Object)this.emf);
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
                this.internalAppScopedEntityManager = false;
                this.env.set("org.kie.persistence.jpa.AppScopedEntityManager", null);
                this.appScopedEntityManager = null;
            }
            this.endCommandScopedEntityManager();
        }
    }

    public ProcessPersistenceContext getProcessPersistenceContext() {
        return new JpaProcessPersistenceContext(this.appScopedEntityManager);
    }

    public void clearPersistenceContext() {
        EntityManager cmdScopedEntityManager;
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM") && (cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.persistence.jpa.CmdScopedEntityManager")) != null) {
            cmdScopedEntityManager.clear();
        }
    }
}

