/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import org.drools.container.spring.MockObjectMarshallingStrategy;
import org.drools.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.marshalling.ObjectMarshallingStrategy;
import org.kie.runtime.Environment;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EnvironmentTest {
    static ClassPathXmlApplicationContext context = null;
    private static Server h2Server;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/drools/container/spring/environment.xml");
    }

    @Test
    public void testCtxNotNull() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testEnvRef() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.transaction.TransactionManager"));
        Assert.assertNotNull((Object)environment.get("org.kie.persistence.jpa.EntityManagerFactory"));
        Assert.assertNotNull((Object)environment.get("org.kie.Globals"));
        Assert.assertNotNull((Object)environment.get("org.kie.build.DateFormats"));
        Assert.assertNotNull((Object)environment.get("org.kie.time.Calendars"));
        Assert.assertNotNull((Object)environment.get("org.kie.marshalling.ObjectMarshallingStrategies"));
        Assert.assertEquals((long)4L, (long)((ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies")).length);
    }

    @Test
    public void testEnvEmb() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-embedded");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.transaction.TransactionManager"));
        Assert.assertNotNull((Object)environment.get("org.kie.persistence.jpa.EntityManagerFactory"));
        Assert.assertNotNull((Object)environment.get("org.kie.Globals"));
        Assert.assertNotNull((Object)environment.get("org.kie.build.DateFormats"));
        Assert.assertNotNull((Object)environment.get("org.kie.time.Calendars"));
        Assert.assertNotNull((Object)environment.get("org.kie.marshalling.ObjectMarshallingStrategies"));
        Assert.assertEquals((long)2L, (long)((ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies")).length);
    }

    @Test
    public void testEnvCustomMarshallerNested() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-nested");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.marshalling.ObjectMarshallingStrategies"));
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)1L, (long)objectMarshallingStrategies.length);
        Assert.assertEquals((Object)objectMarshallingStrategies[0].getClass().getName(), (Object)"org.drools.container.spring.MockObjectMarshallingStrategy");
    }

    @Test
    public void testEnvCustomMarshallerRef() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-ref");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)1L, (long)objectMarshallingStrategies.length);
        Assert.assertEquals((Object)objectMarshallingStrategies[0].getClass().getName(), (Object)"org.drools.container.spring.MockObjectMarshallingStrategy");
    }

    @Test
    public void testEnvMarshallerOrder() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)4L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof ProcessInstanceResolverStrategy));
    }

    @Test
    public void testEnvMarshallerOrderWithCustom() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-mixed");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)5L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof MockObjectMarshallingStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[4] instanceof ProcessInstanceResolverStrategy));
    }
}

