/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.util.ArrayList;
import org.drools.Person;
import org.drools.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.audit.WorkingMemoryConsoleLogger;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.container.spring.beans.KnowledgeLoggerAdaptor;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.runtime.KieSession;
import org.kie.runtime.StatelessKieSession;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsLoggersTest {
    static ClassPathXmlApplicationContext context = null;

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/drools/container/spring/loggers.xml");
    }

    @AfterClass
    public static void runAfterClass() {
        context.close();
    }

    @Test
    public void testStatefulKnowledgeConsoleLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("ConsoleLogger-statefulSession");
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.session.getWorkingMemoryEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
        statefulSession.dispose();
    }

    @Test
    public void testStatefulKnowledgeFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("FileLogger-statefulSession");
        Assert.assertNotNull((Object)statefulSession.getGlobals().get("list"));
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.session.getWorkingMemoryEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        KnowledgeLoggerAdaptor adaptor = (KnowledgeLoggerAdaptor)context.getBean("sf_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
        statefulSession.dispose();
    }

    @Test
    public void testStatefulKnowledgeThreadedFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)context.getBean("ThreadedFileLogger-statefulSession");
        Assert.assertNotNull((Object)statefulSession.getGlobals().get("list"));
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.session.getWorkingMemoryEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        KnowledgeLoggerAdaptor adaptor = (KnowledgeLoggerAdaptor)context.getBean("sf_tfl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
        statefulSession.dispose();
    }

    @Test
    public void testStatelessKnowledgeConsoleLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("ConsoleLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (WorkingMemoryEventListener listener : impl.workingMemoryEventSupport.getEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatelessKnowledgeFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("FileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (WorkingMemoryEventListener listener : impl.workingMemoryEventSupport.getEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        KnowledgeLoggerAdaptor adaptor = (KnowledgeLoggerAdaptor)context.getBean("ss_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessKnowledgeThreadedFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("ThreadedFileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (WorkingMemoryEventListener listener : impl.workingMemoryEventSupport.getEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        KnowledgeLoggerAdaptor loggerAdaptor = (KnowledgeLoggerAdaptor)context.getBean("ss_tfl_logger");
        Assert.assertNotNull((Object)loggerAdaptor);
        Assert.assertNotNull((Object)loggerAdaptor.getRuntimeLogger());
        loggerAdaptor.close();
    }

    @Test
    public void testKSessionLoggersFromGroupAndNested() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("k1");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        Assert.assertEquals((long)2L, (long)impl.workingMemoryEventSupport.getEventListeners().size());
        ArrayList list = new ArrayList();
        statelessKnowledgeSession.setGlobal("list", list);
        Assert.assertNotNull((Object)statelessKnowledgeSession.getGlobals().get("list"));
        statelessKnowledgeSession.execute((Object)new Person("Darth", "Cheddar", 50));
        KnowledgeLoggerAdaptor adaptor = (KnowledgeLoggerAdaptor)context.getBean("k1_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
        adaptor.close();
        adaptor = (KnowledgeLoggerAdaptor)context.getBean("k1_console_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessNoNameFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)context.getBean("FileLogger-statelessSession-noNameLogger");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (WorkingMemoryEventListener listener : impl.workingMemoryEventSupport.getEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
    }
}

