/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import junit.framework.TestCase;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Rule;

public class RuleRenderTest
extends TestCase {
    public void testRuleRender() {
        Rule rule = new Rule("myrule", new Integer(42), 1);
        rule.setComment("rule comments");
        Condition cond = new Condition();
        cond.setComment("cond comment");
        cond.setSnippet("cond snippet");
        rule.addCondition(cond);
        Consequence cons = new Consequence();
        cons.setComment("cons comment");
        cons.setSnippet("cons snippet;");
        rule.addConsequence(cons);
        rule.addConsequence(cons);
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String drl = out.getDRL();
        RuleRenderTest.assertNotNull((Object)drl);
        RuleRenderTest.assertTrue((drl.indexOf("cond snippet") != -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("cons snippet") != -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("salience 42") != -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("salience 42") < drl.indexOf("when") ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("cond snippet") < drl.indexOf("then") ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("cons snippet;") > drl.indexOf("then") ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("rule") != -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("end") > drl.indexOf("rule ") ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((drl.indexOf("#rule comments") > -1 ? 1 : 0) != 0);
    }

    public void testAttributes() throws Exception {
        Rule rule = new Rule("la", new Integer(42), 2);
        rule.setActivationGroup("foo");
        rule.setNoLoop("true");
        rule.setRuleFlowGroup("ruleflowgroup");
        rule.setDuration("42");
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String result = out.toString();
        RuleRenderTest.assertTrue((result.indexOf("ruleflow-group \"ruleflowgroup\"") > -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((result.indexOf("no-loop true") > -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((result.indexOf("activation-group \"foo\"") > -1 ? 1 : 0) != 0);
        RuleRenderTest.assertTrue((result.indexOf("duration 42") > -1 ? 1 : 0) != 0);
    }

    public void testSalienceCalculator() {
        int rowNumber = 2;
        int salience = Rule.calcSalience((int)2);
        RuleRenderTest.assertEquals((int)65533, (int)salience);
    }

    public void testColNumToColName() {
        String colName = Rule.convertColNumToColName((int)1);
        RuleRenderTest.assertEquals((String)"B", (String)colName);
        colName = Rule.convertColNumToColName((int)10);
        RuleRenderTest.assertEquals((String)"K", (String)colName);
        colName = Rule.convertColNumToColName((int)42);
        RuleRenderTest.assertEquals((String)"AQ", (String)colName);
        colName = Rule.convertColNumToColName((int)27);
        RuleRenderTest.assertEquals((String)"AB", (String)colName);
        colName = Rule.convertColNumToColName((int)53);
        RuleRenderTest.assertEquals((String)"BB", (String)colName);
    }

    public void testNotEscapeChars() {
        Condition cond = new Condition();
        cond.setSnippet("a < b");
        DRLOutput out = new DRLOutput();
        cond.renderDRL(out);
        RuleRenderTest.assertTrue((out.toString().indexOf("a < b") != -1 ? 1 : 0) != 0);
    }

    public void testNilSalience() {
        Rule rule = new Rule("MyRule", null, 1);
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String xml = out.toString();
        int idx = xml.indexOf("salience");
        RuleRenderTest.assertEquals((int)-1, (int)idx);
        rule = new Rule("MyRule", new Integer(42), 1);
        out = new DRLOutput();
        rule.renderDRL(out);
        xml = out.toString();
        idx = xml.indexOf("salience");
        RuleRenderTest.assertTrue((idx > -1 ? 1 : 0) != 0);
    }
}

