/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import junit.framework.TestCase;
import org.drools.template.model.SnippetBuilder;

public class SnippetBuilderTest
extends TestCase {
    public void testBuildSnippet() {
        String snippet = "something.param.getAnother().equals($param);";
        SnippetBuilder snip = new SnippetBuilder("something.param.getAnother().equals($param);");
        String cellValue = "$42";
        String result = snip.build("$42");
        SnippetBuilderTest.assertNotNull((Object)result);
        SnippetBuilderTest.assertEquals((String)"something.param.getAnother().equals($42);", (String)result);
    }

    public void testBuildSnippetNoPlaceHolder() {
        String snippet = "something.getAnother().equals(blah);";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother().equals(blah);");
        String cellValue = "this is ignored...";
        String result = snip.build("this is ignored...");
        SnippetBuilderTest.assertEquals((String)"something.getAnother().equals(blah);", (String)result);
    }

    public void testSingleParamMultipleTimes() {
        String snippet = "something.param.getAnother($param).equals($param);";
        SnippetBuilder snip = new SnippetBuilder("something.param.getAnother($param).equals($param);");
        String cellValue = "42";
        String result = snip.build("42");
        SnippetBuilderTest.assertNotNull((Object)result);
        SnippetBuilderTest.assertEquals((String)"something.param.getAnother(42).equals(42);", (String)result);
    }

    public void testMultiPlaceHolder() {
        String snippet = "something.getAnother($1,$2).equals($2, '$2');";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother($1,$2).equals($2, '$2');");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"something.getAnother(x,y).equals(y, 'y');", (String)result);
    }

    public void testMultiPlaceHolderSingle() {
        String snippet = "something.getAnother($1).equals($1);";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother($1).equals($1);");
        String result = snip.build("x");
        SnippetBuilderTest.assertEquals((String)"something.getAnother(x).equals(x);", (String)result);
    }

    public void testStartWithParam() {
        String snippet = "$1 goo $2";
        SnippetBuilder snip = new SnippetBuilder("$1 goo $2");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"x goo y", (String)result);
    }

    public void testMultiPlaceHolderEscapedComma() {
        String snippet = "rulesOutputRouting.set( $1, $2, $3, $4, $5 );";
        SnippetBuilder snip = new SnippetBuilder("rulesOutputRouting.set( $1, $2, $3, $4, $5 );");
        String result = snip.build("\"80\",\"Department Manager\",toa.getPersonExpense().getEntityCode(\"Part Of\"\\,\"Office\"),10004,30");
        SnippetBuilderTest.assertEquals((String)"rulesOutputRouting.set( \"80\", \"Department Manager\", toa.getPersonExpense().getEntityCode(\"Part Of\",\"Office\"), 10004, 30 );", (String)result);
    }

    public void testForAllAnd() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("x");
        SnippetBuilderTest.assertEquals((String)"something == x", (String)result);
    }

    public void testForAllAndCSV() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"something == x && something == y", (String)result);
    }

    public void testForAllAndNone() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("");
        SnippetBuilderTest.assertEquals((String)"forall(&&){something == $}", (String)result);
    }

    public void testForAllAndCSVMultiple() {
        String snippet = "forall(&&){something == $ || something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $ || something == $}");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"something == x || something == x && something == y || something == y", (String)result);
    }

    public void testForAllOr() {
        String snippet = "forall(||){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(||){something == $}");
        String result = snip.build("x");
        SnippetBuilderTest.assertEquals((String)"something == x", (String)result);
    }

    public void testForAllOrMultiple() {
        String snippet = "forall(||){something == $} && forall(||){something < $}";
        SnippetBuilder snip = new SnippetBuilder("forall(||){something == $} && forall(||){something < $}");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"something == x || something == y && something < x || something < y", (String)result);
    }

    public void testForAllOrAndMultipleWithPrefix() {
        String snippet = "something == this && forall(||){something == $} && forall(&&){something < $}";
        SnippetBuilder snip = new SnippetBuilder("something == this && forall(||){something == $} && forall(&&){something < $}");
        String result = snip.build("x, y");
        SnippetBuilderTest.assertEquals((String)"something == this && something == x || something == y && something < x && something < y", (String)result);
    }
}

