/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.template.parser.Column;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;

public class DefaultTemplateContainerTest
extends TestCase {
    public void testParseTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_simple.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        DefaultTemplateContainerTest.assertEquals((String)"package This_is_a_ruleset;\n", (String)t.getHeader());
        DefaultTemplateContainerTest.assertEquals((int)1, (int)t.getColumns().length);
        DefaultTemplateContainerTest.assertEquals((String)"name", (String)t.getColumns()[0].getName());
        Map templates = t.getTemplates();
        DefaultTemplateContainerTest.assertEquals((int)1, (int)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        DefaultTemplateContainerTest.assertNotNull((Object)template);
        List columns = template.getColumns();
        DefaultTemplateContainerTest.assertEquals((int)1, (int)columns.size());
        TemplateColumn column = (TemplateColumn)columns.get(0);
        DefaultTemplateContainerTest.assertEquals((String)"name", (String)column.getName());
        String contents = template.getContents();
        DefaultTemplateContainerTest.assertTrue((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\""));
        DefaultTemplateContainerTest.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }

    public void testParseTemplateConditions() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_conditions.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        DefaultTemplateContainerTest.assertEquals((String)"package This_is_a_ruleset;\n", (String)t.getHeader());
        DefaultTemplateContainerTest.assertEquals((int)1, (int)t.getColumns().length);
        DefaultTemplateContainerTest.assertEquals((String)"name", (String)t.getColumns()[0].getName());
        Map templates = t.getTemplates();
        DefaultTemplateContainerTest.assertEquals((int)1, (int)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        DefaultTemplateContainerTest.assertNotNull((Object)template);
        List columns = template.getColumns();
        DefaultTemplateContainerTest.assertEquals((int)1, (int)columns.size());
        TemplateColumn templateColumn = (TemplateColumn)columns.get(0);
        DefaultTemplateContainerTest.assertEquals((String)"name", (String)templateColumn.getName());
        DefaultTemplateContainerTest.assertEquals((String)"== \"name1\"", (String)templateColumn.getCondition());
        String contents = template.getContents();
        DefaultTemplateContainerTest.assertTrue((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\""));
        DefaultTemplateContainerTest.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }

    public void testParseTemplateNoHeader() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid1.drl");
            new DefaultTemplateContainer(is);
            DefaultTemplateContainerTest.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            DefaultTemplateContainerTest.assertEquals((String)"Missing header", (String)expected.getMessage());
        }
    }

    public void testParseTemplateNoHeaderColumns() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid2.drl");
            new DefaultTemplateContainer(is);
            DefaultTemplateContainerTest.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            DefaultTemplateContainerTest.assertEquals((String)"Missing header columns", (String)expected.getMessage());
        }
    }

    public void testParseTemplateNoTemplates() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid3.drl");
            new DefaultTemplateContainer(is);
            DefaultTemplateContainerTest.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            DefaultTemplateContainerTest.assertEquals((String)"Missing templates", (String)expected.getMessage());
        }
    }

    public void testParseTemplateNoEndTemplate() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid4.drl");
            new DefaultTemplateContainer(is);
            DefaultTemplateContainerTest.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            DefaultTemplateContainerTest.assertEquals((String)"Missing end template", (String)expected.getMessage());
        }
    }

    public void testNullInputStream() {
        try {
            new DefaultTemplateContainer((InputStream)null);
            DefaultTemplateContainerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testInvalidTemplatePath() {
        try {
            new DefaultTemplateContainer("invalid path");
            DefaultTemplateContainerTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseComplexTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_complex.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        DefaultTemplateContainerTest.assertEquals((String)"package This_is_a_ruleset;\n", (String)t.getHeader());
        Column[] columnList = t.getColumns();
        DefaultTemplateContainerTest.assertEquals((int)5, (int)columnList.length);
        DefaultTemplateContainerTest.assertEquals((String)"first_name", (String)columnList[0].getName());
        DefaultTemplateContainerTest.assertEquals((String)"last_name", (String)columnList[1].getName());
        DefaultTemplateContainerTest.assertEquals((String)"age", (String)columnList[2].getName());
        DefaultTemplateContainerTest.assertEquals((String)"city", (String)columnList[3].getName());
        DefaultTemplateContainerTest.assertEquals((String)"phone", (String)columnList[4].getName());
        DefaultTemplateContainerTest.assertEquals((Object)columnList[1], (Object)t.getColumn("last_name"));
        Map templates = t.getTemplates();
        DefaultTemplateContainerTest.assertEquals((int)2, (int)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        DefaultTemplateContainerTest.assertNotNull((Object)template);
        List columns = template.getColumns();
        DefaultTemplateContainerTest.assertEquals((int)1, (int)columns.size());
        TemplateColumn column = (TemplateColumn)columns.get(0);
        DefaultTemplateContainerTest.assertEquals((String)"first_name", (String)column.getName());
        String contents = template.getContents();
        DefaultTemplateContainerTest.assertTrue((boolean)contents.startsWith("rule \"How cool is @{first_name} @{row.rowNumber}\""));
        DefaultTemplateContainerTest.assertTrue((boolean)contents.endsWith("then\nend\n"));
        template = (RuleTemplate)templates.get("template2");
        DefaultTemplateContainerTest.assertNotNull((Object)template);
        columns = template.getColumns();
        DefaultTemplateContainerTest.assertEquals((int)2, (int)columns.size());
        column = (TemplateColumn)columns.get(0);
        DefaultTemplateContainerTest.assertEquals((String)"first_name", (String)column.getName());
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        DefaultTemplateContainerTest.assertEquals((String)"last_name", (String)column2.getName());
        contents = template.getContents();
        DefaultTemplateContainerTest.assertTrue((boolean)contents.startsWith("rule \"How uncool is @{first_name} @{row.rowNumber}\""));
        DefaultTemplateContainerTest.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }
}

