/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.Agenda;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemoryEntryPoint;
import org.drools.concurrent.Future;
import org.drools.event.AgendaEventListener;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.event.SignalManager;
import org.drools.process.instance.timer.TimerManager;
import org.drools.runtime.Environment;
import org.drools.runtime.ObjectFilter;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.GlobalResolver;
import org.drools.template.parser.Column;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringCell;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.template.parser.TemplateDataListener;
import org.drools.template.parser.TemplateRuleBase;
import org.drools.time.SessionClock;

public class ExternalSheetListenerTest
extends TestCase {
    private TemplateDataListener esl;
    private Map<Row, List<StringCell>> assertedRows = new HashMap<Row, List<StringCell>>();
    private List<StringCell> currentRow = new ArrayList<StringCell>();

    protected void setUp() throws Exception {
        this.esl = new TemplateDataListener(2, 2, (TemplateContainer)new TestTemplateContainer(), (TemplateRuleBase)new TestTemplateRuleBase(), (Generator)new TestGenerator());
    }

    public void testRenderDrl() {
        String drl = this.esl.renderDRL();
        ExternalSheetListenerTest.assertEquals((String)"Test Template Header\nTest Generated DRL\n", (String)drl);
    }

    public void testRowHandling() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.finishSheet();
        ExternalSheetListenerTest.assertEquals((int)2, (int)this.assertedRows.size());
        for (Map.Entry<Row, List<StringCell>> entry : this.assertedRows.entrySet()) {
            Row row = entry.getKey();
            List<StringCell> cells = entry.getValue();
            int i = 1;
            for (StringCell cell : cells) {
                ExternalSheetListenerTest.assertEquals((Object)("row" + row.getRowNumber() + "col" + i), (Object)cell.getValue());
                ExternalSheetListenerTest.assertEquals((String)("Pattern " + i), (String)cell.getColumn().getName());
                ++i;
            }
        }
    }

    public void testRowHandlingBlankRows() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.newRow(3, 3);
        this.esl.newCell(3, 0, "", 0);
        this.esl.newCell(3, 1, "", 0);
        this.esl.newCell(3, 2, "", 0);
        this.esl.newRow(4, 3);
        this.esl.newCell(4, 0, "", 0);
        this.esl.newCell(4, 1, "", 0);
        this.esl.newCell(4, 2, "", 0);
        this.esl.finishSheet();
        ExternalSheetListenerTest.assertEquals((int)2, (int)this.assertedRows.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestTemplateContainer
    implements TemplateContainer {
        private TestTemplateContainer() {
        }

        public void addColumn(Column c) {
        }

        public void addTemplate(RuleTemplate template) {
        }

        public Column[] getColumns() {
            return new Column[]{new StringColumn("Pattern 1"), new StringColumn("Pattern 2"), new StringColumn("Pattern 3")};
        }

        public String getHeader() {
            return "Test Template Header";
        }

        public Map<String, RuleTemplate> getTemplates() {
            return null;
        }

        public void setHeader(String head) {
        }

        public void setTemplates(Map<String, RuleTemplate> templates) {
        }

        public Column getColumn(String name) {
            return null;
        }
    }

    private class TestGenerator
    implements Generator {
        private TestGenerator() {
        }

        public void generate(String templateName, Row row) {
        }

        public String getDrl() {
            return "Test Generated DRL";
        }
    }

    private class TestTemplateRuleBase
    implements TemplateRuleBase {
        private TestTemplateRuleBase() {
        }

        public StatefulSession newStatefulSession() {
            return new StatefulSession(){
                private static final long serialVersionUID = 1L;

                public void addEventListener(WorkingMemoryEventListener arg0) {
                }

                public void addEventListener(AgendaEventListener arg0) {
                }

                public void addEventListener(RuleFlowEventListener arg0) {
                }

                public FactHandle insert(Object fact) throws FactException {
                    if (fact instanceof Row) {
                        ExternalSheetListenerTest.this.assertedRows.put((Row)fact, ExternalSheetListenerTest.this.currentRow);
                        ExternalSheetListenerTest.this.currentRow = new ArrayList();
                    } else if (fact instanceof StringCell) {
                        ExternalSheetListenerTest.this.currentRow.add((StringCell)fact);
                    }
                    return null;
                }

                public FactHandle insert(Object arg0, boolean arg1) throws FactException {
                    return null;
                }

                public void clearAgenda() {
                }

                public void clearAgendaGroup(String arg0) {
                }

                public void dispose() {
                }

                public int fireAllRules() throws FactException {
                    return 0;
                }

                public int fireAllRules(AgendaFilter arg0) throws FactException {
                    return 0;
                }

                public Agenda getAgenda() {
                    return null;
                }

                public List getAgendaEventListeners() {
                    return null;
                }

                public FactHandle getFactHandle(Object arg0) {
                    return null;
                }

                public AgendaGroup getFocus() {
                    return null;
                }

                public Object getGlobal(String arg0) {
                    return null;
                }

                public Object getObject(FactHandle arg0) {
                    return null;
                }

                public QueryResults getQueryResults(String arg0) {
                    return null;
                }

                public RuleBase getRuleBase() {
                    return null;
                }

                public List getWorkingMemoryEventListeners() {
                    return null;
                }

                public void update(org.drools.runtime.rule.FactHandle arg0, Object arg1) throws FactException {
                }

                public void removeEventListener(WorkingMemoryEventListener arg0) {
                }

                public void removeEventListener(AgendaEventListener arg0) {
                }

                public void removeEventListener(RuleFlowEventListener arg0) {
                }

                public void retract(org.drools.runtime.rule.FactHandle arg0) throws FactException {
                }

                public void setAsyncExceptionHandler(AsyncExceptionHandler arg0) {
                }

                public void setFocus(String arg0) {
                }

                public void setFocus(AgendaGroup arg0) {
                }

                public void setGlobal(String arg0, Object arg1) {
                }

                public void setGlobalResolver(GlobalResolver globalResolver) {
                }

                public ProcessInstance startProcess(String processId) {
                    return null;
                }

                public Iterator iterateFactHandles() {
                    return null;
                }

                public Iterator iterateFactHandles(ObjectFilter filter) {
                    return null;
                }

                public Iterator iterateObjects() {
                    return null;
                }

                public Iterator iterateObjects(ObjectFilter filter) {
                    return null;
                }

                public Future asyncInsert(Object object) {
                    return null;
                }

                public Future asyncInsert(Object[] list) {
                    return null;
                }

                public Future asyncInsert(Collection collection) {
                    return null;
                }

                public Future asyncFireAllRules() {
                    return null;
                }

                public Future asyncFireAllRules(AgendaFilter agendaFilter) {
                    return null;
                }

                public Future asyncUpdate(FactHandle factHandle, Object object) {
                    return null;
                }

                public Future asyncRetract(FactHandle factHandle) {
                    return null;
                }

                public QueryResults getQueryResults(String query, Object[] arguments) {
                    return null;
                }

                public void modifyInsert(FactHandle factHandle, Object object) {
                }

                public void modifyRetract(FactHandle factHandle) {
                }

                public void halt() {
                }

                public int fireAllRules(int fireLimit) throws FactException {
                    return 0;
                }

                public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) throws FactException {
                    return 0;
                }

                public GlobalResolver getGlobalResolver() {
                    return null;
                }

                public List getRuleFlowEventListeners() {
                    return null;
                }

                public void clearActivationGroup(String group) {
                }

                public void clearRuleFlowGroup(String group) {
                }

                public void addEventListener(RuleBaseEventListener listener) {
                }

                public List getRuleBaseEventListeners() {
                    return null;
                }

                public void removeEventListener(RuleBaseEventListener listener) {
                }

                public List getRuleBaseUpdateListeners() {
                    return null;
                }

                public ProcessInstance getProcessInstance(long id) {
                    return null;
                }

                public WorkItemManager getWorkItemManager() {
                    return null;
                }

                public Collection getProcessInstances() {
                    return null;
                }

                public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
                    return null;
                }

                public FactHandle getFactHandleByIdentity(Object object) {
                    return null;
                }

                public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String id) {
                    return null;
                }

                public TimerManager getTimerManager() {
                    return null;
                }

                public SessionClock getSessionClock() {
                    return null;
                }

                public SignalManager getSignalManager() {
                    return null;
                }

                public void fireUntilHalt() {
                }

                public void fireUntilHalt(AgendaFilter agendaFilter) {
                }

                public Object getObject(org.drools.runtime.rule.FactHandle handle) {
                    return null;
                }

                public Environment getEnvironment() {
                    return null;
                }

                public Collection<? extends org.drools.runtime.rule.FactHandle> getFactHandles() {
                    return null;
                }

                public Collection<? extends org.drools.runtime.rule.FactHandle> getFactHandles(ObjectFilter filter) {
                    return null;
                }

                public Collection<Object> getObjects() {
                    return null;
                }

                public Collection<Object> getObjects(ObjectFilter filter) {
                    return null;
                }

                public String getEntryPointId() {
                    return null;
                }

                public long getFactCount() {
                    return 0L;
                }
            };
        }
    }
}

