/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.core.util.StringUtils;
import org.drools.template.parser.Column;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.drools.template.parser.TemplateContainer;

public class RuleTemplateTest
extends TestCase {
    public void testSetContents() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.setContents("Test template");
        RuleTemplateTest.assertEquals((String)"Test template\n", (String)rt.getContents());
    }

    private TemplateContainer getTemplateContainer() {
        return new TemplateContainer(){

            public Column getColumn(String name) {
                return null;
            }

            public Column[] getColumns() {
                return null;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                return null;
            }
        };
    }

    public void testAddColumn() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.addColumn("StandardColumn");
        rt.addColumn("!NotColumn");
        rt.addColumn("ColumnCondition == \"test\"");
        rt.addColumn("!NotColumnCondition == \"test2\"");
        rt.addColumn("ArrayColumnCondition[0] == \"test2\"");
        List columns = rt.getColumns();
        RuleTemplateTest.assertEquals((int)5, (int)columns.size());
        TemplateColumn column1 = (TemplateColumn)columns.get(0);
        RuleTemplateTest.assertEquals((String)"StandardColumn", (String)column1.getName());
        RuleTemplateTest.assertFalse((boolean)column1.isNotCondition());
        RuleTemplateTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)column1.getCondition()));
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        RuleTemplateTest.assertEquals((String)"NotColumn", (String)column2.getName());
        RuleTemplateTest.assertTrue((boolean)column2.isNotCondition());
        RuleTemplateTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)column2.getCondition()));
        TemplateColumn column3 = (TemplateColumn)columns.get(2);
        RuleTemplateTest.assertEquals((String)"ColumnCondition", (String)column3.getName());
        RuleTemplateTest.assertFalse((boolean)column3.isNotCondition());
        RuleTemplateTest.assertEquals((String)"== \"test\"", (String)column3.getCondition());
        TemplateColumn column4 = (TemplateColumn)columns.get(3);
        RuleTemplateTest.assertEquals((String)"NotColumnCondition", (String)column4.getName());
        RuleTemplateTest.assertTrue((boolean)column4.isNotCondition());
        RuleTemplateTest.assertEquals((String)"== \"test2\"", (String)column4.getCondition());
    }
}

