/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.rule.GroupElement;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.VariableConstraint;
import org.drools.template.parser.Column;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.DefaultTemplateRuleBase;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;

public class DefaultTemplateRuleBaseTest
extends TestCase {
    public void testSimpleTemplate() throws Exception {
        TemplateContainer tc = new TemplateContainer(){
            private Column[] columns = new Column[]{new LongColumn("column1"), new LongColumn("column2"), new StringColumn("column3")};

            public Column[] getColumns() {
                return this.columns;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                HashMap<String, RuleTemplate> templates = new HashMap<String, RuleTemplate>();
                RuleTemplate ruleTemplate = new RuleTemplate("template1", (TemplateContainer)this);
                ruleTemplate.addColumn("column1 == 10");
                ruleTemplate.addColumn("column2 < 5 || > 20");
                ruleTemplate.addColumn("column3 == \"xyz\"");
                templates.put("template1", ruleTemplate);
                return templates;
            }

            public Column getColumn(String name) {
                return this.columns[Integer.parseInt(name.substring(6)) - 1];
            }
        };
        DefaultTemplateRuleBase ruleBase = new DefaultTemplateRuleBase(tc);
        Package[] packages = ruleBase.newStatefulSession().getRuleBase().getPackages();
        DefaultTemplateRuleBaseTest.assertEquals((int)1, (int)packages.length);
        Map globals = packages[0].getGlobals();
        DefaultTemplateRuleBaseTest.assertEquals((String)DefaultGenerator.class.getName(), (String)((String)globals.get("generator")));
        Rule[] rules = packages[0].getRules();
        DefaultTemplateRuleBaseTest.assertEquals((int)1, (int)rules.length);
        DefaultTemplateRuleBaseTest.assertEquals((String)"template1", (String)rules[0].getName());
        GroupElement lhs = rules[0].getLhs();
        DefaultTemplateRuleBaseTest.assertEquals((int)7, (int)lhs.getChildren().size());
        Pattern pattern = (Pattern)lhs.getChildren().get(1);
        DefaultTemplateRuleBaseTest.assertEquals((int)1, (int)pattern.getConstraints().size());
        LiteralConstraint constraint = (LiteralConstraint)pattern.getConstraints().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((Object)"column1", (Object)constraint.getField().getValue());
        GroupElement exists = (GroupElement)lhs.getChildren().get(2);
        pattern = (Pattern)exists.getChildren().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((int)3, (int)pattern.getConstraints().size());
        VariableConstraint vconstraint = (VariableConstraint)pattern.getConstraints().get(1);
        DefaultTemplateRuleBaseTest.assertEquals(Column.class, (Object)vconstraint.getFieldExtractor().getExtractToClass());
        DefaultTemplateRuleBaseTest.assertEquals((String)"column1", (String)vconstraint.getRequiredDeclarations()[0].getIdentifier());
        pattern = (Pattern)lhs.getChildren().get(3);
        DefaultTemplateRuleBaseTest.assertEquals((int)1, (int)pattern.getConstraints().size());
        constraint = (LiteralConstraint)pattern.getConstraints().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((Object)"column2", (Object)constraint.getField().getValue());
        exists = (GroupElement)lhs.getChildren().get(4);
        pattern = (Pattern)exists.getChildren().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((int)3, (int)pattern.getConstraints().size());
        vconstraint = (VariableConstraint)pattern.getConstraints().get(1);
        DefaultTemplateRuleBaseTest.assertEquals(Column.class, (Object)vconstraint.getFieldExtractor().getExtractToClass());
        DefaultTemplateRuleBaseTest.assertEquals((String)"column2", (String)vconstraint.getRequiredDeclarations()[0].getIdentifier());
        pattern = (Pattern)lhs.getChildren().get(5);
        DefaultTemplateRuleBaseTest.assertEquals((int)1, (int)pattern.getConstraints().size());
        constraint = (LiteralConstraint)pattern.getConstraints().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((Object)"column3", (Object)constraint.getField().getValue());
        exists = (GroupElement)lhs.getChildren().get(6);
        pattern = (Pattern)exists.getChildren().get(0);
        DefaultTemplateRuleBaseTest.assertEquals((int)3, (int)pattern.getConstraints().size());
        vconstraint = (VariableConstraint)pattern.getConstraints().get(1);
        DefaultTemplateRuleBaseTest.assertEquals(Column.class, (Object)vconstraint.getFieldExtractor().getExtractToClass());
        DefaultTemplateRuleBaseTest.assertEquals((String)"column3", (String)vconstraint.getRequiredDeclarations()[0].getIdentifier());
    }
}

