/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLElement;
import org.drools.template.model.DRLJavaEmitter;
import org.drools.template.model.DRLOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends DRLElement
implements DRLJavaEmitter {
    private static final int MAX_ROWS = 65535;
    private Integer _salience;
    private String _name;
    private String _duration;
    private String _description;
    private String _noLoop;
    private String _activationGroup;
    private String _ruleFlowGroup;
    private String _agendaGroup;
    private List<Condition> _lhs;
    private List<Consequence> _rhs;
    private int _spreadsheetRow;

    public Rule(String name, Integer salience, int spreadsheetRow) {
        this._name = name;
        this._salience = salience;
        this._description = "";
        this._lhs = new LinkedList<Condition>();
        this._rhs = new LinkedList<Consequence>();
        this._spreadsheetRow = spreadsheetRow;
    }

    public void addCondition(Condition con) {
        this._lhs.add(con);
    }

    public void addConsequence(Consequence con) {
        this._rhs.add(con);
    }

    @Override
    public void renderDRL(DRLOutput out) {
        if (this.isCommented()) {
            out.writeLine("#" + this.getComment());
        }
        out.writeLine("rule \"" + this._name + "\"");
        if (this._description != null) {
            out.writeLine("\t" + this._description);
        }
        if (this._salience != null) {
            out.writeLine("\tsalience " + this._salience);
        }
        if (this._activationGroup != null) {
            out.writeLine("\tactivation-group \"" + this._activationGroup + "\"");
        }
        if (this._agendaGroup != null) {
            out.writeLine("\tagenda-group " + this._agendaGroup);
        }
        if (this._noLoop != null) {
            out.writeLine("\tno-loop " + this._noLoop);
        }
        if (this._duration != null) {
            out.writeLine("\tduration " + this._duration);
        }
        if (this._ruleFlowGroup != null) {
            out.writeLine("\truleflow-group \"" + this._ruleFlowGroup + "\"");
        }
        out.writeLine("\twhen");
        this.renderDRL(this._lhs, out);
        out.writeLine("\tthen");
        this.renderDRL(this._rhs, out);
        out.writeLine("end\n");
    }

    private void renderDRL(List<? extends DRLJavaEmitter> list, DRLOutput out) {
        for (DRLJavaEmitter dRLJavaEmitter : list) {
            dRLJavaEmitter.renderDRL(out);
        }
    }

    public static int calcSalience(int rowNumber) {
        if (rowNumber > 65535) {
            throw new IllegalArgumentException("That row number is above the max: 65535");
        }
        return 65535 - rowNumber;
    }

    public static String convertColNumToColName(int i) {
        String result;
        int div = i / 26;
        int mod = i % 26;
        if (div == 0) {
            byte[] c = new byte[]{(byte)(mod + 65)};
            result = Rule.byteToString(c);
        } else {
            byte[] firstChar = new byte[]{(byte)(div - 1 + 65)};
            byte[] secondChar = new byte[]{(byte)(mod + 65)};
            String first = Rule.byteToString(firstChar);
            String second = Rule.byteToString(secondChar);
            result = String.valueOf(first) + second;
        }
        return result;
    }

    private static String byteToString(byte[] secondChar) {
        try {
            return new String(secondChar, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert char to string.", e);
        }
    }

    public List<Condition> getConditions() {
        return this._lhs;
    }

    public List<Consequence> getConsequences() {
        return this._rhs;
    }

    public void setSalience(Integer value) {
        this._salience = value;
    }

    public Integer getSalience() {
        return this._salience;
    }

    public void setName(String value) {
        this._name = value;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void appendDescription(String value) {
        this._description = String.valueOf(this._description) + value;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDuration(String value) {
        this._duration = value;
    }

    public String getDuration() {
        return this._duration;
    }

    public void setActivationGroup(String value) {
        this._activationGroup = value;
    }

    public void setRuleFlowGroup(String value) {
        this._ruleFlowGroup = value;
    }

    public String getRuleFlowGroup() {
        return this._ruleFlowGroup;
    }

    public String getActivationGroup() {
        return this._activationGroup;
    }

    public String getAgendaGroup() {
        return this._agendaGroup;
    }

    public void setAgendaGroup(String group) {
        this._agendaGroup = group;
    }

    public void setNoLoop(String value) {
        this._noLoop = value;
    }

    public int getSpreadsheetRowNumber() {
        return this._spreadsheetRow;
    }
}

