/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnippetBuilder {
    private static final String PARAM_PREFIX = "$";
    private static final String PARAM = "$param";
    private final String _template;
    private final boolean single;
    private final Pattern delimiter;

    public SnippetBuilder(String snippetTemplate) {
        if (snippetTemplate == null) {
            throw new RuntimeException("Script template is null - check for missing script definition.");
        }
        this._template = snippetTemplate;
        this.single = this._template.indexOf("$1") < 0;
        this.delimiter = Pattern.compile("(.*?[^\\\\])(,|\\z)");
    }

    public String build(String cellValue) {
        if (this.single) {
            return this.buildSingle(cellValue);
        }
        return this.buildMulti(cellValue);
    }

    private String buildMulti(String cellValue) {
        String[] cellVals = this.split(cellValue);
        String result = this._template;
        int paramNumber = 0;
        while (paramNumber < cellVals.length) {
            String replace = PARAM_PREFIX + (paramNumber + 1);
            result = this.replace(result, replace, cellVals[paramNumber].trim(), 256);
            ++paramNumber;
        }
        return result;
    }

    private String[] split(String input) {
        Matcher m = this.delimiter.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1).replaceAll("\\\\,", ","));
        }
        return result.toArray(new String[result.size()]);
    }

    private String buildSingle(String cellValue) {
        return this.replace(this._template, PARAM, cellValue, 256);
    }

    private String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || repl.equals("") || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

