/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Map;
import org.drools.StatefulSession;
import org.drools.core.util.StringUtils;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCell
implements Cell {
    Row row;
    String value;
    ArrayColumn column;
    private String[] values;

    public ArrayCell(Row r, ArrayColumn c) {
        this.row = r;
        this.column = c;
    }

    @Override
    public void addValue(Map<String, Object> vars) {
        int i = 0;
        while (i < this.values.length) {
            vars.put(String.valueOf(this.column.getName()) + i, this.values[i]);
            ++i;
        }
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void insert(StatefulSession session) {
        session.insert((Object)this);
        int i = 0;
        while (i < this.values.length) {
            Cell cell = this.column.getType().createCell(this.row);
            cell.setValue(this.values[i]);
            cell.setIndex(i);
            cell.insert(session);
            ++i;
        }
    }

    @Override
    public void setIndex(int i) {
        throw new RuntimeException("You cannot call setIndex on an ArrayCell");
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @Override
    public void setValue(String v) {
        this.value = v;
        this.values = StringUtils.splitPreserveAllTokens((String)this.value, (String)",");
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.value);
    }
}

