/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.drools.template.parser.Column;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTemplateContainerTest {
    @Test
    public void testParseTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_simple.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assert.assertEquals((Object)"package This_is_a_ruleset;\n", (Object)t.getHeader());
        Assert.assertEquals((long)1L, (long)t.getColumns().length);
        Assert.assertEquals((Object)"name", (Object)t.getColumns()[0].getName());
        Map templates = t.getTemplates();
        Assert.assertEquals((long)1L, (long)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assert.assertNotNull((Object)template);
        List columns = template.getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assert.assertEquals((Object)"name", (Object)column.getName());
        String contents = template.getContents();
        Assert.assertTrue((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\""));
        Assert.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }

    @Test
    public void testParseTemplateIndentedKeywords() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/rule_template_indented.drl");
        new DefaultTemplateContainer(is);
    }

    @Test
    public void testParseTemplateConditions() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_conditions.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assert.assertEquals((Object)"package This_is_a_ruleset;\n", (Object)t.getHeader());
        Assert.assertEquals((long)1L, (long)t.getColumns().length);
        Assert.assertEquals((Object)"name", (Object)t.getColumns()[0].getName());
        Map templates = t.getTemplates();
        Assert.assertEquals((long)1L, (long)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assert.assertNotNull((Object)template);
        List columns = template.getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        TemplateColumn templateColumn = (TemplateColumn)columns.get(0);
        Assert.assertEquals((Object)"name", (Object)templateColumn.getName());
        Assert.assertEquals((Object)"== \"name1\"", (Object)templateColumn.getCondition());
        String contents = template.getContents();
        Assert.assertTrue((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\""));
        Assert.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }

    @Test
    public void testParseTemplateNoHeader() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid1.drl");
            new DefaultTemplateContainer(is);
            Assert.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assert.assertEquals((Object)"Missing header", (Object)expected.getMessage());
        }
    }

    @Test
    public void testParseTemplateNoHeaderColumns() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid2.drl");
            new DefaultTemplateContainer(is);
            Assert.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assert.assertEquals((Object)"Missing header columns", (Object)expected.getMessage());
        }
    }

    @Test
    public void testParseTemplateNoTemplates() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid3.drl");
            new DefaultTemplateContainer(is);
            Assert.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assert.assertEquals((Object)"Missing templates", (Object)expected.getMessage());
        }
    }

    @Test
    public void testParseTemplateNoEndTemplate() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid4.drl");
            new DefaultTemplateContainer(is);
            Assert.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assert.assertEquals((Object)"Missing end template", (Object)expected.getMessage());
        }
    }

    @Test
    public void testNullInputStream() {
        try {
            new DefaultTemplateContainer((InputStream)null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidTemplatePath() {
        try {
            new DefaultTemplateContainer("invalid path");
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testParseComplexTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_complex.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assert.assertEquals((Object)"package This_is_a_ruleset;\n", (Object)t.getHeader());
        Column[] columnList = t.getColumns();
        Assert.assertEquals((long)5L, (long)columnList.length);
        Assert.assertEquals((Object)"first_name", (Object)columnList[0].getName());
        Assert.assertEquals((Object)"last_name", (Object)columnList[1].getName());
        Assert.assertEquals((Object)"age", (Object)columnList[2].getName());
        Assert.assertEquals((Object)"city", (Object)columnList[3].getName());
        Assert.assertEquals((Object)"phone", (Object)columnList[4].getName());
        Assert.assertEquals((Object)columnList[1], (Object)t.getColumn("last_name"));
        Map templates = t.getTemplates();
        Assert.assertEquals((long)2L, (long)templates.size());
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assert.assertNotNull((Object)template);
        List columns = template.getColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assert.assertEquals((Object)"first_name", (Object)column.getName());
        String contents = template.getContents();
        Assert.assertTrue((boolean)contents.startsWith("rule \"How cool is @{first_name} @{row.rowNumber}\""));
        Assert.assertTrue((boolean)contents.endsWith("then\nend\n"));
        template = (RuleTemplate)templates.get("template2");
        Assert.assertNotNull((Object)template);
        columns = template.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        column = (TemplateColumn)columns.get(0);
        Assert.assertEquals((Object)"first_name", (Object)column.getName());
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        Assert.assertEquals((Object)"last_name", (Object)column2.getName());
        contents = template.getContents();
        Assert.assertTrue((boolean)contents.startsWith("rule \"How uncool is @{first_name} @{row.rowNumber}\""));
        Assert.assertTrue((boolean)contents.endsWith("then\nend\n"));
    }
}

