/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.HashMap;
import java.util.Map;
import org.drools.rule.GroupElement;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.spi.Constraint;
import org.drools.template.parser.Column;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.DefaultTemplateRuleBase;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTemplateRuleBaseTest {
    @Test
    public void testSimpleTemplate() throws Exception {
        TemplateContainer tc = new TemplateContainer(){
            private Column[] columns = new Column[]{new LongColumn("column1"), new LongColumn("column2"), new StringColumn("column3")};

            public Column[] getColumns() {
                return this.columns;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                HashMap<String, RuleTemplate> templates = new HashMap<String, RuleTemplate>();
                RuleTemplate ruleTemplate = new RuleTemplate("template1", (TemplateContainer)this);
                ruleTemplate.addColumn("column1 == 10");
                ruleTemplate.addColumn("column2 < 5 || > 20");
                ruleTemplate.addColumn("column3 == \"xyz\"");
                templates.put("template1", ruleTemplate);
                return templates;
            }

            public Column getColumn(String name) {
                return this.columns[Integer.parseInt(name.substring(6)) - 1];
            }
        };
        DefaultTemplateRuleBase ruleBase = new DefaultTemplateRuleBase(tc);
        Package[] packages = ruleBase.newStatefulSession().getRuleBase().getPackages();
        Assert.assertEquals((long)1L, (long)packages.length);
        Map globals = packages[0].getGlobals();
        Assert.assertEquals((Object)DefaultGenerator.class.getName(), globals.get("generator"));
        Rule[] rules = packages[0].getRules();
        Assert.assertEquals((long)1L, (long)rules.length);
        Assert.assertEquals((Object)"template1", (Object)rules[0].getName());
        GroupElement lhs = rules[0].getLhs();
        Assert.assertEquals((long)7L, (long)lhs.getChildren().size());
        Pattern pattern = (Pattern)lhs.getChildren().get(1);
        Assert.assertEquals((long)1L, (long)pattern.getConstraints().size());
        Constraint constraint = (Constraint)pattern.getConstraints().get(0);
        GroupElement exists = (GroupElement)lhs.getChildren().get(2);
        pattern = (Pattern)exists.getChildren().get(0);
        Assert.assertEquals((long)3L, (long)pattern.getConstraints().size());
        IndexableConstraint vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assert.assertEquals(Column.class, (Object)vconstraint.getFieldIndex().getExtractor().getExtractToClass());
        Assert.assertEquals((Object)"column1", (Object)vconstraint.getRequiredDeclarations()[0].getIdentifier());
        pattern = (Pattern)lhs.getChildren().get(3);
        Assert.assertEquals((long)1L, (long)pattern.getConstraints().size());
        constraint = (Constraint)pattern.getConstraints().get(0);
        exists = (GroupElement)lhs.getChildren().get(4);
        pattern = (Pattern)exists.getChildren().get(0);
        Assert.assertEquals((long)3L, (long)pattern.getConstraints().size());
        vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assert.assertEquals(Column.class, (Object)vconstraint.getFieldIndex().getExtractor().getExtractToClass());
        Assert.assertEquals((Object)"column2", (Object)vconstraint.getRequiredDeclarations()[0].getIdentifier());
        pattern = (Pattern)lhs.getChildren().get(5);
        Assert.assertEquals((long)1L, (long)pattern.getConstraints().size());
        constraint = (Constraint)pattern.getConstraints().get(0);
        exists = (GroupElement)lhs.getChildren().get(6);
        pattern = (Pattern)exists.getChildren().get(0);
        Assert.assertEquals((long)3L, (long)pattern.getConstraints().size());
        vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assert.assertEquals(Column.class, (Object)vconstraint.getFieldIndex().getExtractor().getExtractToClass());
        Assert.assertEquals((Object)"column3", (Object)vconstraint.getRequiredDeclarations()[0].getIdentifier());
    }
}

