/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.drools.WorkingMemory;
import org.drools.common.NetworkNode;
import org.drools.core.util.debug.AccumulateNodeVisitor;
import org.drools.core.util.debug.AlphaNodeVisitor;
import org.drools.core.util.debug.BetaNodeVisitor;
import org.drools.core.util.debug.DefaultNetworkNodeVisitor;
import org.drools.core.util.debug.EvalConditionNodeVisitor;
import org.drools.core.util.debug.FromNodeVisitor;
import org.drools.core.util.debug.LeftInputAdapterNodeVisitor;
import org.drools.core.util.debug.NetworkNodeVisitor;
import org.drools.core.util.debug.ObjectTypeNodeVisitor;
import org.drools.core.util.debug.PropagationQueueingNodeVisitor;
import org.drools.core.util.debug.QueryTerminalNodeVisitor;
import org.drools.core.util.debug.RightInputAdapterNodeVisitor;
import org.drools.core.util.debug.RuleTerminalNodeVisitor;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.ReteooWorkingMemoryInterface;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Rule;
import org.kie.runtime.StatefulKnowledgeSession;

public class SessionInspector {
    private ReteooWorkingMemoryInterface session;
    private Map<Class<? extends NetworkNode>, NetworkNodeVisitor> visitors = new HashMap<Class<? extends NetworkNode>, NetworkNodeVisitor>();

    public SessionInspector(StatefulKnowledgeSession session) {
        this.visitors.put(RuleTerminalNode.class, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put(QueryTerminalNode.class, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put(Rete.class, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(EntryPointNode.class, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(ObjectTypeNode.class, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put(AlphaNode.class, AlphaNodeVisitor.INSTANCE);
        this.visitors.put(RightInputAdapterNode.class, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(PropagationQueuingNode.class, PropagationQueueingNodeVisitor.INSTANCE);
        this.visitors.put(JoinNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(NotNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(ExistsNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(AccumulateNode.class, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put(EvalConditionNode.class, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put(FromNode.class, FromNodeVisitor.INSTANCE);
        this.visitors.put(LeftInputAdapterNode.class, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = ((StatefulKnowledgeSessionImpl)session).session;
    }

    public SessionInspector(WorkingMemory session) {
        this.visitors.put(RuleTerminalNode.class, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put(QueryTerminalNode.class, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put(Rete.class, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(EntryPointNode.class, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put(ObjectTypeNode.class, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put(AlphaNode.class, AlphaNodeVisitor.INSTANCE);
        this.visitors.put(RightInputAdapterNode.class, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put(PropagationQueuingNode.class, PropagationQueueingNodeVisitor.INSTANCE);
        this.visitors.put(JoinNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(NotNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(ExistsNode.class, BetaNodeVisitor.INSTANCE);
        this.visitors.put(AccumulateNode.class, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put(EvalConditionNode.class, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put(FromNode.class, FromNodeVisitor.INSTANCE);
        this.visitors.put(LeftInputAdapterNode.class, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (ReteooWorkingMemory)session;
    }

    public StatefulKnowledgeSessionInfo getSessionInfo() {
        StatefulKnowledgeSessionInfo info = new StatefulKnowledgeSessionInfo();
        ReteooRuleBase rulebase = (ReteooRuleBase)this.session.getRuleBase();
        info.setSession(this.session);
        Stack<NetworkNode> nodeStack = new Stack<NetworkNode>();
        this.gatherNodeInfo(rulebase.getRete(), nodeStack, info);
        return info;
    }

    private void gatherNodeInfo(NetworkNode parent, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (!info.visited(parent)) {
            nodeStack.push(parent);
            NetworkNodeVisitor visitor = this.visitors.get(parent.getClass());
            if (visitor == null) {
                throw new RuntimeException("No visitor found for node class: " + parent.getClass() + " node: " + parent);
            }
            visitor.visit(parent, nodeStack, info);
            this.visitChildren(parent, nodeStack, info);
            nodeStack.pop();
        } else {
            Set<Rule> rules = info.getNodeInfo(parent).getRules();
            for (NetworkNode snode : nodeStack) {
                for (Rule rule : rules) {
                    info.assign(snode, rule);
                }
            }
        }
    }

    protected void visitChildren(NetworkNode parent, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (parent instanceof Rete) {
            Rete rete = (Rete)parent;
            for (EntryPointNode sink : rete.getEntryPointNodes().values()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)parent;
            for (ObjectTypeNode sink : epn.getObjectTypeNodes().values()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)parent;
            for (ObjectSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)parent;
            for (LeftTupleSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (!(parent instanceof RuleTerminalNode) && !(parent instanceof QueryTerminalNode)) {
            throw new RuntimeException("ERROR: No idea how to visit childrens of this node: " + parent);
        }
    }
}

