/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;

public class VetoableTypedMap<T extends String, K extends Thing>
implements Map<String, Thing>,
Serializable {
    private Map<String, Thing> innerMap;
    private PriorityQueue<Perm> vetos;

    public VetoableTypedMap(Map map) {
        this.innerMap = map;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public Thing get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public Thing put(String key, Thing value) {
        this.innerMap.put(key, value);
        return value;
    }

    public Thing putSafe(String key, Thing value) throws LogicalTypeInconsistencyException {
        if (this.vetos != null) {
            for (Perm ward : this.vetos) {
                if (!ward.getType().isAssignableFrom(value.getClass())) continue;
                if (!ward.isWard()) break;
                throw new LogicalTypeInconsistencyException("An object of type " + value.getCore().getClass() + " has been prevented from donning type " + ward.getType(), value.getCore().getClass(), ward.getType());
            }
        }
        this.innerMap.put(key, value);
        return value;
    }

    @Override
    public Thing remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Thing> m) {
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<Thing> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, Thing>> entrySet() {
        return this.innerMap.entrySet();
    }

    public void addToVetoable(Class trait) throws LogicalTypeInconsistencyException {
        if (this.vetos == null) {
            this.vetos = new PriorityQueue();
        }
        if (!this.vetos.contains(new Perm(trait))) {
            this.vetos.add(new Perm(trait, true));
            for (Thing t : this.innerMap.values()) {
                if (!trait.isAssignableFrom(t.getClass())) continue;
                Class<?> c1 = t.getClass();
                Class c2 = trait;
                throw new LogicalTypeInconsistencyException("An object of type " + c1 + " has been prevented from donning type " + c2, c1, c2);
            }
        }
    }

    public void removeFromVetoable(Class trait) {
        Perm test;
        if (this.vetos == null) {
            this.vetos = new PriorityQueue();
        }
        if (this.vetos.contains(test = new Perm(trait))) {
            this.vetos.remove(test);
        } else {
            this.vetos.add(new Perm(trait, false));
        }
    }

    public String toString() {
        return "VetoableTypedMap{innerMap=" + this.innerMap + ", vetos=" + this.vetos + '}';
    }

    private static class Perm
    implements Comparable<Perm>,
    Serializable {
        private Class<? extends Thing> type;
        private boolean ward;
        private int depth;

        private Perm(Class<? extends Thing> type) {
            this.type = type;
        }

        private Perm(Class<? extends Thing> type, boolean ward) {
            this.type = type;
            this.ward = ward;
            this.depth = 1;
            Class<?> sup = type.getInterfaces()[0];
            while (sup != null && !Thing.class.equals(sup)) {
                ++this.depth;
                sup = sup.getInterfaces()[0];
            }
        }

        public Class<? extends Thing> getType() {
            return this.type;
        }

        public void setType(Class<? extends Thing> type) {
            this.type = type;
        }

        public boolean isWard() {
            return this.ward;
        }

        public void setWard(boolean ward) {
            this.ward = ward;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Perm perm = (Perm)o;
            return !(this.type != null ? !this.type.equals(perm.type) : perm.type != null);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        @Override
        public int compareTo(Perm o) {
            if (this.getType().isAssignableFrom(o.getType())) {
                return 1;
            }
            if (o.getType().isAssignableFrom(this.getType())) {
                return -1;
            }
            return this.depth - o.depth;
        }

        public String toString() {
            return "Perm{type=" + this.type.getName() + ", ward=" + this.ward + ", depth=" + this.depth + '}';
        }
    }
}

