/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.core.datatype.impl.type;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.process.core.datatype.DataType;

public class ObjectDataType
implements DataType {
    private static final long serialVersionUID = 510L;
    private String className;

    public ObjectDataType() {
    }

    public ObjectDataType(String className) {
        this.setClassName(className);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(this.className);
            if (clazz.isInstance(value)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find data type " + this.className);
        }
        return false;
    }

    @Override
    public Object readValue(String value) {
        XStream xstream = new XStream();
        return xstream.fromXML(value);
    }

    @Override
    public String writeValue(Object value) {
        XStream xstream = new XStream();
        return xstream.toXML(value);
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }
}

