/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Map;
import org.drools.StatefulSession;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;

public class LongCell
implements Cell {
    Row row;
    Long value;
    Column column;
    private int index;

    public LongCell() {
    }

    LongCell(Row r, Column c) {
        this.row = r;
        this.column = c;
    }

    public String toString() {
        return "Cell[" + this.column + ": " + this.value + "]";
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    public Long getValue() {
        return this.value;
    }

    @Override
    public void addValue(Map<String, Object> vars) {
        vars.put(this.column.getName(), this.value);
    }

    @Override
    public void insert(StatefulSession session) {
        session.insert((Object)this);
    }

    @Override
    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setValue(String v) {
        this.value = new Long(v);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }
}

