/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.Agenda;
import org.drools.core.FactException;
import org.drools.core.QueryResults;
import org.drools.core.RuleBase;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.AsyncExceptionHandler;
import org.drools.core.spi.GlobalResolver;
import org.drools.template.parser.Column;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringCell;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.template.parser.TemplateDataListener;
import org.drools.template.parser.TemplateRuleBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionClock;

public class ExternalSheetListenerTest {
    private TemplateDataListener esl;
    private Map<Row, List<StringCell>> assertedRows = new HashMap<Row, List<StringCell>>();
    private List<StringCell> currentRow = new ArrayList<StringCell>();

    @Before
    public void setUp() throws Exception {
        this.esl = new TemplateDataListener(2, 2, (TemplateContainer)new TestTemplateContainer(), (TemplateRuleBase)new TestTemplateRuleBase(), (Generator)new TestGenerator());
    }

    @Test
    public void testRenderDrl() {
        String drl = this.esl.renderDRL();
        Assert.assertEquals((Object)"Test Template Header\nTest Generated DRL\n", (Object)drl);
    }

    @Test
    public void testRowHandling() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.finishSheet();
        Assert.assertEquals((long)2L, (long)this.assertedRows.size());
        for (Map.Entry<Row, List<StringCell>> entry : this.assertedRows.entrySet()) {
            Row row = entry.getKey();
            List<StringCell> cells = entry.getValue();
            int i = 1;
            for (StringCell cell : cells) {
                Assert.assertEquals((Object)("row" + row.getRowNumber() + "col" + i), (Object)cell.getValue());
                Assert.assertEquals((Object)("Pattern " + i), (Object)cell.getColumn().getName());
                ++i;
            }
        }
    }

    @Test
    public void testRowHandlingBlankRows() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.newRow(3, 3);
        this.esl.newCell(3, 0, "", 0);
        this.esl.newCell(3, 1, "", 0);
        this.esl.newCell(3, 2, "", 0);
        this.esl.newRow(4, 3);
        this.esl.newCell(4, 0, "", 0);
        this.esl.newCell(4, 1, "", 0);
        this.esl.newCell(4, 2, "", 0);
        this.esl.finishSheet();
        Assert.assertEquals((long)2L, (long)this.assertedRows.size());
    }

    private class TestTemplateContainer
    implements TemplateContainer {
        private TestTemplateContainer() {
        }

        public void addColumn(Column c) {
        }

        public void addTemplate(RuleTemplate template) {
        }

        public Column[] getColumns() {
            return new Column[]{new StringColumn("Pattern 1"), new StringColumn("Pattern 2"), new StringColumn("Pattern 3")};
        }

        public String getHeader() {
            return "Test Template Header";
        }

        public Map<String, RuleTemplate> getTemplates() {
            return null;
        }

        public void setHeader(String head) {
        }

        public void setTemplates(Map<String, RuleTemplate> templates) {
        }

        public Column getColumn(String name) {
            return null;
        }
    }

    private class TestGenerator
    implements Generator {
        private TestGenerator() {
        }

        public void generate(String templateName, Row row) {
        }

        public String getDrl() {
            return "Test Generated DRL";
        }
    }

    private class TestTemplateRuleBase
    implements TemplateRuleBase {
        private TestTemplateRuleBase() {
        }

        public StatefulSession newStatefulSession() {
            return new StatefulSession(){
                private static final long serialVersionUID = 510L;

                public void addEventListener(WorkingMemoryEventListener arg0) {
                }

                public void addEventListener(AgendaEventListener arg0) {
                }

                public org.drools.core.FactHandle insert(Object fact) throws FactException {
                    if (fact instanceof Row) {
                        ExternalSheetListenerTest.this.assertedRows.put((Row)fact, ExternalSheetListenerTest.this.currentRow);
                        ExternalSheetListenerTest.this.currentRow = new ArrayList();
                    } else if (fact instanceof StringCell) {
                        ExternalSheetListenerTest.this.currentRow.add((StringCell)fact);
                    }
                    return null;
                }

                public org.drools.core.FactHandle insert(Object arg0, boolean arg1) throws FactException {
                    return null;
                }

                public void clearAgenda() {
                }

                public void clearAgendaGroup(String arg0) {
                }

                public void dispose() {
                }

                public int fireAllRules() throws FactException {
                    return 0;
                }

                public int fireAllRules(AgendaFilter arg0) throws FactException {
                    return 0;
                }

                public Agenda getAgenda() {
                    return null;
                }

                public List getAgendaEventListeners() {
                    return null;
                }

                public org.drools.core.FactHandle getFactHandle(Object arg0) {
                    return null;
                }

                public AgendaGroup getFocus() {
                    return null;
                }

                public Object getGlobal(String arg0) {
                    return null;
                }

                public QueryResults getQueryResults(String arg0) {
                    return null;
                }

                public RuleBase getRuleBase() {
                    return null;
                }

                public List getWorkingMemoryEventListeners() {
                    return null;
                }

                public void update(FactHandle arg0, Object arg1) throws FactException {
                }

                public void removeEventListener(WorkingMemoryEventListener arg0) {
                }

                public void removeEventListener(AgendaEventListener arg0) {
                }

                public void retract(FactHandle arg0) throws FactException {
                }

                public void delete(FactHandle arg0) throws FactException {
                }

                public void setAsyncExceptionHandler(AsyncExceptionHandler arg0) {
                }

                public void setFocus(String arg0) {
                }

                public void setFocus(AgendaGroup arg0) {
                }

                public void setGlobal(String arg0, Object arg1) {
                }

                public void setGlobalResolver(GlobalResolver globalResolver) {
                }

                public ProcessInstance startProcess(String processId) {
                    return null;
                }

                public Iterator iterateFactHandles() {
                    return null;
                }

                public Iterator iterateFactHandles(ObjectFilter filter) {
                    return null;
                }

                public Iterator iterateObjects() {
                    return null;
                }

                public Iterator iterateObjects(ObjectFilter filter) {
                    return null;
                }

                public QueryResults getQueryResults(String query, Object[] arguments) {
                    return null;
                }

                public void modifyInsert(org.drools.core.FactHandle factHandle, Object object) {
                }

                public void modifyRetract(org.drools.core.FactHandle factHandle) {
                }

                public void halt() {
                }

                public int fireAllRules(int fireLimit) throws FactException {
                    return 0;
                }

                public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) throws FactException {
                    return 0;
                }

                public GlobalResolver getGlobalResolver() {
                    return null;
                }

                public List getRuleFlowEventListeners() {
                    return null;
                }

                public void clearActivationGroup(String group) {
                }

                public void clearRuleFlowGroup(String group) {
                }

                public void addEventListener(RuleBaseEventListener listener) {
                }

                public List getRuleBaseEventListeners() {
                    return null;
                }

                public void removeEventListener(RuleBaseEventListener listener) {
                }

                public List getRuleBaseUpdateListeners() {
                    return null;
                }

                public ProcessInstance getProcessInstance(long id) {
                    return null;
                }

                public ProcessInstance getProcessInstance(long id, boolean readOnly) {
                    return null;
                }

                public WorkItemManager getWorkItemManager() {
                    return null;
                }

                public Collection getProcessInstances() {
                    return null;
                }

                public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
                    return null;
                }

                public org.drools.core.FactHandle getFactHandleByIdentity(Object object) {
                    return null;
                }

                public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String id) {
                    return null;
                }

                public SessionClock getSessionClock() {
                    return null;
                }

                public void fireUntilHalt() {
                }

                public void fireUntilHalt(AgendaFilter agendaFilter) {
                }

                public Object getObject(FactHandle handle) {
                    return null;
                }

                public Environment getEnvironment() {
                    return null;
                }

                public Collection<? extends FactHandle> getFactHandles() {
                    return null;
                }

                public Collection<? extends FactHandle> getFactHandles(ObjectFilter filter) {
                    return null;
                }

                public Collection<? extends Object> getObjects() {
                    return null;
                }

                public Collection<? extends Object> getObjects(ObjectFilter filter) {
                    return null;
                }

                public String getEntryPointId() {
                    return null;
                }

                public long getFactCount() {
                    return 0L;
                }
            };
        }
    }
}

