/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.template.jdbc.Cheese;
import org.drools.template.jdbc.Person;
import org.drools.template.jdbc.ResultSetGenerator;
import org.junit.Assert;
import org.junit.Test;

public class ResultSetGeneratorTest {
    @Test
    public void testResultSet() throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        Connection conn = DriverManager.getConnection("jdbc:hsqldb:mem:drools-templates", "sa", "");
        try {
            this.update("CREATE TABLE cheese_rules ( id INTEGER IDENTITY, persons_age INTEGER, birth_date DATE, cheese_type VARCHAR(256), log VARCHAR(256) )", conn);
            this.update("INSERT INTO cheese_rules(persons_age,birth_date,cheese_type,log) VALUES(42, '1950-01-01', 'stilton', 'Old man stilton')", conn);
            this.update("INSERT INTO cheese_rules(persons_age,birth_date,cheese_type,log) VALUES(10, '2009-01-01', 'cheddar', 'Young man cheddar')", conn);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not initialize in memory database", e);
        }
        Statement sta = conn.createStatement();
        ResultSet rs = sta.executeQuery("SELECT persons_age, cheese_type, log  FROM cheese_rules");
        ResultSetGenerator converter = new ResultSetGenerator();
        String drl = converter.compile(rs, this.getRulesStream());
        System.out.println(drl);
        sta.close();
        RuleBase rb = this.buildRuleBase(drl);
        StatefulSession wm = rb.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 42));
        wm.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    private RuleBase buildRuleBase(String ... drls) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        for (String drl : drls) {
            builder.addPackageFromDrl((Reader)new StringReader(drl));
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        return ruleBase;
    }

    private InputStream getRulesStream() {
        return this.getClass().getResourceAsStream("/templates/Cheese.drt");
    }

    private void update(String expression, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
        st.close();
    }
}

