/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.HashMap;
import java.util.Map;
import org.drools.template.parser.Column;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultGeneratorTest {
    private DefaultGenerator g;

    @Before
    public void setUp() throws Exception {
        HashMap<String, RuleTemplate> t = new HashMap<String, RuleTemplate>();
        TemplateContainer tc = new TemplateContainer(){

            public Column getColumn(String name) {
                return null;
            }

            public Column[] getColumns() {
                return null;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                return null;
            }
        };
        RuleTemplate rt1 = new RuleTemplate("rt1", tc);
        rt1.setContents("Test template 1");
        RuleTemplate rt2 = new RuleTemplate("rt2", tc);
        rt2.setContents("Test template 2");
        RuleTemplate rt3 = new RuleTemplate("rt3", tc);
        rt3.addColumn("col1");
        rt3.addColumn("col2");
        rt3.setContents("@{row.rowNumber} @{col1} @{col2}");
        t.put("rt1", rt1);
        t.put("rt2", rt2);
        t.put("rt3", rt3);
        this.g = new DefaultGenerator(t);
    }

    @Test
    public void testSelectTemplate() {
        this.g.generate("rt2", new Row());
        String drl = this.g.getDrl();
        Assert.assertEquals((Object)"Test template 2\n\n", (Object)drl);
    }

    @Test
    public void testGenerate() {
        this.g.generate("rt2", new Row());
        this.g.generate("rt1", new Row());
        String drl = this.g.getDrl();
        Assert.assertEquals((Object)"Test template 2\n\nTest template 1\n\n", (Object)drl);
    }

    @Test
    public void testAddColumns() {
        Column[] columns = new Column[]{new StringColumn("col1"), new StringColumn("col2")};
        Row r = new Row(1, columns);
        r.getCell(0).setValue("value1");
        r.getCell(1).setValue("value2");
        this.g.generate("rt3", r);
        String drl = this.g.getDrl();
        Assert.assertEquals((Object)"1 value1 value2\n\n", (Object)drl);
    }
}

