/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.template.parser.Column;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringCell;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.template.parser.TemplateDataListener;
import org.drools.template.parser.TemplateRuleBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;

public class ExternalSheetListenerTest {
    private TemplateDataListener esl;
    private Map<Row, List<StringCell>> assertedRows = new HashMap<Row, List<StringCell>>();
    private List<StringCell> currentRow = new ArrayList<StringCell>();

    @Before
    public void setUp() throws Exception {
        this.esl = new TemplateDataListener(2, 2, (TemplateContainer)new TestTemplateContainer(), (TemplateRuleBase)new TestTemplateRuleBase(), (Generator)new TestGenerator());
    }

    @Test
    public void testRenderDrl() {
        String drl = this.esl.renderDRL();
        Assert.assertEquals((Object)"Test Template Header\nTest Generated DRL\n", (Object)drl);
    }

    @Test
    public void testRowHandling() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.finishSheet();
        Assert.assertEquals((long)2L, (long)this.assertedRows.size());
        for (Map.Entry<Row, List<StringCell>> entry : this.assertedRows.entrySet()) {
            Row row = entry.getKey();
            List<StringCell> cells = entry.getValue();
            int i = 1;
            for (StringCell cell : cells) {
                Assert.assertEquals((Object)("row" + row.getRowNumber() + "col" + i), (Object)cell.getValue());
                Assert.assertEquals((Object)("Pattern " + i), (Object)cell.getColumn().getName());
                ++i;
            }
        }
    }

    @Test
    public void testRowHandlingBlankRows() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.newRow(3, 3);
        this.esl.newCell(3, 0, "", 0);
        this.esl.newCell(3, 1, "", 0);
        this.esl.newCell(3, 2, "", 0);
        this.esl.newRow(4, 3);
        this.esl.newCell(4, 0, "", 0);
        this.esl.newCell(4, 1, "", 0);
        this.esl.newCell(4, 2, "", 0);
        this.esl.finishSheet();
        Assert.assertEquals((long)2L, (long)this.assertedRows.size());
    }

    private class TestTemplateContainer
    implements TemplateContainer {
        private TestTemplateContainer() {
        }

        public void addColumn(Column c) {
        }

        public void addTemplate(RuleTemplate template) {
        }

        public Column[] getColumns() {
            return new Column[]{new StringColumn("Pattern 1"), new StringColumn("Pattern 2"), new StringColumn("Pattern 3")};
        }

        public String getHeader() {
            return "Test Template Header";
        }

        public Map<String, RuleTemplate> getTemplates() {
            return null;
        }

        public void setHeader(String head) {
        }

        public void setTemplates(Map<String, RuleTemplate> templates) {
        }

        public Column getColumn(String name) {
            return null;
        }
    }

    private class TestGenerator
    implements Generator {
        private TestGenerator() {
        }

        public void generate(String templateName, Row row) {
        }

        public String getDrl() {
            return "Test Generated DRL";
        }
    }

    private class TestTemplateRuleBase
    implements TemplateRuleBase {
        private TestTemplateRuleBase() {
        }

        public KieSession newStatefulSession() {
            return new KieSession(){

                public int getId() {
                    return 0;
                }

                public long getIdentifier() {
                    return 0L;
                }

                public void dispose() {
                }

                public void destroy() {
                }

                public void submit(KieSession.AtomicAction action) {
                }

                public <T> T getKieRuntime(Class<T> cls) {
                    return null;
                }

                public <T> T execute(Command<T> command) {
                    return null;
                }

                public <T extends SessionClock> T getSessionClock() {
                    return null;
                }

                public void setGlobal(String identifier, Object value) {
                }

                public Object getGlobal(String identifier) {
                    return null;
                }

                public Globals getGlobals() {
                    return null;
                }

                public Calendars getCalendars() {
                    return null;
                }

                public Environment getEnvironment() {
                    return null;
                }

                public KieBase getKieBase() {
                    return null;
                }

                public void registerChannel(String name, Channel channel) {
                }

                public void unregisterChannel(String name) {
                }

                public Map<String, Channel> getChannels() {
                    return null;
                }

                public KieSessionConfiguration getSessionConfiguration() {
                    return null;
                }

                public void halt() {
                }

                public Agenda getAgenda() {
                    return null;
                }

                public EntryPoint getEntryPoint(String name) {
                    return null;
                }

                public Collection<? extends EntryPoint> getEntryPoints() {
                    return null;
                }

                public QueryResults getQueryResults(String query, Object ... arguments) {
                    return null;
                }

                public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
                    return null;
                }

                public String getEntryPointId() {
                    return null;
                }

                public FactHandle insert(Object fact) {
                    if (fact instanceof Row) {
                        ExternalSheetListenerTest.this.assertedRows.put((Row)fact, ExternalSheetListenerTest.this.currentRow);
                        ExternalSheetListenerTest.this.currentRow = new ArrayList();
                    } else if (fact instanceof StringCell) {
                        ExternalSheetListenerTest.this.currentRow.add((StringCell)fact);
                    }
                    return null;
                }

                public void retract(FactHandle handle) {
                }

                public void delete(FactHandle handle) {
                }

                public void delete(FactHandle handle, FactHandle.State fhState) {
                }

                public void update(FactHandle handle, Object object) {
                }

                public void update(FactHandle handle, Object object, String ... modifiedProperties) {
                }

                public FactHandle getFactHandle(Object object) {
                    return null;
                }

                public Object getObject(FactHandle factHandle) {
                    return null;
                }

                public Collection<? extends Object> getObjects() {
                    return null;
                }

                public Collection<? extends Object> getObjects(ObjectFilter filter) {
                    return null;
                }

                public <T extends FactHandle> Collection<T> getFactHandles() {
                    return null;
                }

                public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
                    return null;
                }

                public long getFactCount() {
                    return 0L;
                }

                public KieRuntimeLogger getLogger() {
                    return null;
                }

                public void addEventListener(ProcessEventListener listener) {
                }

                public void removeEventListener(ProcessEventListener listener) {
                }

                public Collection<ProcessEventListener> getProcessEventListeners() {
                    return null;
                }

                public ProcessInstance startProcess(String processId) {
                    return null;
                }

                public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
                    return null;
                }

                public ProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
                    return null;
                }

                public ProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
                    return null;
                }

                public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
                    return null;
                }

                public ProcessInstance startProcessInstance(long processInstanceId) {
                    return null;
                }

                public void signalEvent(String type, Object event) {
                }

                public void signalEvent(String type, Object event, long processInstanceId) {
                }

                public Collection<ProcessInstance> getProcessInstances() {
                    return null;
                }

                public ProcessInstance getProcessInstance(long processInstanceId) {
                    return null;
                }

                public ProcessInstance getProcessInstance(long processInstanceId, boolean readonly) {
                    return null;
                }

                public void abortProcessInstance(long processInstanceId) {
                }

                public WorkItemManager getWorkItemManager() {
                    return null;
                }

                public void addEventListener(RuleRuntimeEventListener listener) {
                }

                public void removeEventListener(RuleRuntimeEventListener listener) {
                }

                public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
                    return null;
                }

                public void addEventListener(AgendaEventListener listener) {
                }

                public void removeEventListener(AgendaEventListener listener) {
                }

                public Collection<AgendaEventListener> getAgendaEventListeners() {
                    return null;
                }

                public int fireAllRules() {
                    return 0;
                }

                public int fireAllRules(int max) {
                    return 0;
                }

                public int fireAllRules(AgendaFilter agendaFilter) {
                    return 0;
                }

                public int fireAllRules(AgendaFilter agendaFilter, int max) {
                    return 0;
                }

                public void fireUntilHalt() {
                }

                public void fireUntilHalt(AgendaFilter agendaFilter) {
                }

                public ProcessInstance startProcessFromNodeIds(String processId, Map<String, Object> params, String ... nodeIds) {
                    return null;
                }
            };
        }
    }
}

