/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import org.drools.template.model.SnippetBuilder;
import org.junit.Assert;
import org.junit.Test;

public class SnippetBuilderTest {
    @Test
    public void testBuildSnippet() {
        String snippet = "something.param.getAnother().equals($param);";
        SnippetBuilder snip = new SnippetBuilder("something.param.getAnother().equals($param);");
        String cellValue = "$42";
        String result = snip.build("$42");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"something.param.getAnother().equals($42);", (Object)result);
    }

    @Test
    public void testBuildSnippetNoPlaceHolder() {
        String snippet = "something.getAnother().equals(blah);";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother().equals(blah);");
        String cellValue = "this is ignored...";
        String result = snip.build("this is ignored...");
        Assert.assertEquals((Object)"something.getAnother().equals(blah);", (Object)result);
    }

    @Test
    public void testSingleParamMultipleTimes() {
        String snippet = "something.param.getAnother($param).equals($param);";
        SnippetBuilder snip = new SnippetBuilder("something.param.getAnother($param).equals($param);");
        String cellValue = "42";
        String result = snip.build("42");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"something.param.getAnother(42).equals(42);", (Object)result);
    }

    @Test
    public void testMultiPlaceHolder() {
        String snippet = "something.getAnother($1,$2).equals($2, '$2');";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother($1,$2).equals($2, '$2');");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"something.getAnother(x,y).equals(y, 'y');", (Object)result);
    }

    @Test
    public void testMultiPlaceHolderSingle() {
        String snippet = "something.getAnother($1).equals($1);";
        SnippetBuilder snip = new SnippetBuilder("something.getAnother($1).equals($1);");
        String result = snip.build("x");
        Assert.assertEquals((Object)"something.getAnother(x).equals(x);", (Object)result);
    }

    @Test
    public void testStartWithParam() {
        String snippet = "$1 goo $2";
        SnippetBuilder snip = new SnippetBuilder("$1 goo $2");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"x goo y", (Object)result);
    }

    @Test
    public void testMultiPlaceHolderEscapedComma() {
        String snippet = "rulesOutputRouting.set( $1, $2, $3, $4, $5 );";
        SnippetBuilder snip = new SnippetBuilder("rulesOutputRouting.set( $1, $2, $3, $4, $5 );");
        String result = snip.build("\"80\",\"Department Manager\",toa.getPersonExpense().getEntityCode(\"Part Of\",\"Office\"),10004,30");
        Assert.assertEquals((Object)"rulesOutputRouting.set( \"80\", \"Department Manager\", toa.getPersonExpense().getEntityCode(\"Part Of\",\"Office\"), 10004, 30 );", (Object)result);
    }

    @Test
    public void testForAllAnd() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("x");
        Assert.assertEquals((Object)"something == x", (Object)result);
    }

    @Test
    public void testForAllAndCSV() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"something == x && something == y", (Object)result);
    }

    @Test
    public void testForAllAndNone() {
        String snippet = "forall(&&){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $}");
        String result = snip.build("");
        Assert.assertEquals((Object)"forall(&&){something == $}", (Object)result);
    }

    @Test
    public void testForAllAndCSVMultiple() {
        String snippet = "forall(&&){something == $ || something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(&&){something == $ || something == $}");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"something == x || something == x && something == y || something == y", (Object)result);
    }

    @Test
    public void testForAllOr() {
        String snippet = "forall(||){something == $}";
        SnippetBuilder snip = new SnippetBuilder("forall(||){something == $}");
        String result = snip.build("x");
        Assert.assertEquals((Object)"something == x", (Object)result);
    }

    @Test
    public void testForAllOrMultiple() {
        String snippet = "forall(||){something == $} && forall(||){something < $}";
        SnippetBuilder snip = new SnippetBuilder("forall(||){something == $} && forall(||){something < $}");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"something == x || something == y && something < x || something < y", (Object)result);
    }

    @Test
    public void testForAllOrAndMultipleWithPrefix() {
        String snippet = "something == this && forall(||){something == $} && forall(&&){something < $}";
        SnippetBuilder snip = new SnippetBuilder("something == this && forall(||){something == $} && forall(&&){something < $}");
        String result = snip.build("x, y");
        Assert.assertEquals((Object)"something == this && something == x || something == y && something < x && something < y", (Object)result);
    }
}

