/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import org.assertj.core.api.Assertions;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Column;
import org.drools.template.parser.ColumnFactory;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.StringColumn;
import org.junit.Test;

public class ColumnFactoryTest {
    @Test
    public void testGetColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column");
        Assertions.assertThat((boolean)(column instanceof StringColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
    }

    @Test
    public void testGetStringArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: String[]");
        Assertions.assertThat((boolean)(column instanceof ArrayColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetLongArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long[]");
        Assertions.assertThat((boolean)(column instanceof ArrayColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("LongCell");
    }

    @Test
    public void testGetArrayColumnSimple() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column[]");
        Assertions.assertThat((boolean)(column instanceof ArrayColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetLongColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long");
        Assertions.assertThat((boolean)(column instanceof LongColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
    }

    @Test
    public void testInvalidGetColumn() {
        try {
            ColumnFactory f = new ColumnFactory();
            f.getColumn("column$");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDollarColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("$column");
        Assertions.assertThat((boolean)(column instanceof StringColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("$column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetDollarArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("$column[]");
        Assertions.assertThat((boolean)(column instanceof ArrayColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("$column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetDollarTypedColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("$column: Long");
        Assertions.assertThat((boolean)(column instanceof LongColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("$column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("LongCell");
    }

    @Test
    public void testGetDollarArrayTypedColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("$column: Long[]");
        Assertions.assertThat((boolean)(column instanceof ArrayColumn)).isTrue();
        Assertions.assertThat((String)column.getName()).isEqualTo("$column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("LongCell");
    }
}

