/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Constraint;
import org.drools.template.parser.Column;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.DefaultTemplateRuleBase;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.junit.Test;
import org.kie.api.definition.rule.Rule;

public class DefaultTemplateRuleBaseTest {
    @Test
    public void testSimpleTemplate() throws Exception {
        TemplateContainer tc = new TemplateContainer(){
            private Column[] columns = new Column[]{new LongColumn("column1"), new LongColumn("column2"), new StringColumn("column3")};

            public Column[] getColumns() {
                return this.columns;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                HashMap<String, RuleTemplate> templates = new HashMap<String, RuleTemplate>();
                RuleTemplate ruleTemplate = new RuleTemplate("template1", (TemplateContainer)this);
                ruleTemplate.addColumn("column1 == 10");
                ruleTemplate.addColumn("column2 < 5 || > 20");
                ruleTemplate.addColumn("column3 == \"xyz\"");
                templates.put("template1", ruleTemplate);
                return templates;
            }

            public Column getColumn(String name) {
                return this.columns[Integer.parseInt(name.substring(6)) - 1];
            }
        };
        DefaultTemplateRuleBase ruleBase = new DefaultTemplateRuleBase(tc);
        InternalKnowledgePackage[] packages = ((KnowledgeBaseImpl)ruleBase.newStatefulSession().getKieBase()).getPackages();
        Assertions.assertThat((int)packages.length).isEqualTo(1);
        Map globals = packages[0].getGlobals();
        Assertions.assertThat((Class)((Class)globals.get("generator"))).isEqualTo(DefaultGenerator.class);
        Collection rules = packages[0].getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(1);
        Assertions.assertThat((String)((Rule)rules.iterator().next()).getName()).isEqualTo("template1");
        GroupElement lhs = ((RuleImpl)rules.iterator().next()).getLhs();
        Assertions.assertThat((int)lhs.getChildren().size()).isEqualTo(7);
        Pattern pattern = (Pattern)lhs.getChildren().get(1);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(1);
        Constraint constraint = (Constraint)pattern.getConstraints().get(0);
        GroupElement exists = (GroupElement)lhs.getChildren().get(2);
        pattern = (Pattern)exists.getChildren().get(0);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(3);
        IndexableConstraint vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assertions.assertThat((Class)vconstraint.getFieldIndex().getRightExtractor().getExtractToClass()).isEqualTo(Column.class);
        Assertions.assertThat((String)vconstraint.getRequiredDeclarations()[0].getIdentifier()).isEqualTo("column1");
        pattern = (Pattern)lhs.getChildren().get(3);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(1);
        constraint = (Constraint)pattern.getConstraints().get(0);
        exists = (GroupElement)lhs.getChildren().get(4);
        pattern = (Pattern)exists.getChildren().get(0);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(3);
        vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assertions.assertThat((Class)vconstraint.getFieldIndex().getRightExtractor().getExtractToClass()).isEqualTo(Column.class);
        Assertions.assertThat((String)vconstraint.getRequiredDeclarations()[0].getIdentifier()).isEqualTo("column2");
        pattern = (Pattern)lhs.getChildren().get(5);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(1);
        constraint = (Constraint)pattern.getConstraints().get(0);
        exists = (GroupElement)lhs.getChildren().get(6);
        pattern = (Pattern)exists.getChildren().get(0);
        Assertions.assertThat((int)pattern.getConstraints().size()).isEqualTo(3);
        vconstraint = (IndexableConstraint)pattern.getConstraints().get(1);
        Assertions.assertThat((Class)vconstraint.getFieldIndex().getRightExtractor().getExtractToClass()).isEqualTo(Column.class);
        Assertions.assertThat((String)vconstraint.getRequiredDeclarations()[0].getIdentifier()).isEqualTo("column3");
    }
}

