/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.template.parser.Column;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.drools.template.parser.TemplateContainer;
import org.junit.Assert;
import org.junit.Test;

public class RuleTemplateTest {
    @Test
    public void testSetContents() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.setContents("Test template");
        Assert.assertEquals((Object)"Test template\n", (Object)rt.getContents());
    }

    private TemplateContainer getTemplateContainer() {
        return new TemplateContainer(){

            public Column getColumn(String name) {
                return null;
            }

            public Column[] getColumns() {
                return null;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                return null;
            }
        };
    }

    @Test
    public void testAddColumn() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.addColumn("StandardColumn");
        rt.addColumn("!NotColumn");
        rt.addColumn("ColumnCondition == \"test\"");
        rt.addColumn("!NotColumnCondition == \"test2\"");
        rt.addColumn("ArrayColumnCondition[0] == \"test2\"");
        List columns = rt.getColumns();
        Assert.assertEquals((long)5L, (long)columns.size());
        TemplateColumn column1 = (TemplateColumn)columns.get(0);
        Assert.assertEquals((Object)"StandardColumn", (Object)column1.getName());
        Assert.assertFalse((boolean)column1.isNotCondition());
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)column1.getCondition()));
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        Assert.assertEquals((Object)"NotColumn", (Object)column2.getName());
        Assert.assertTrue((boolean)column2.isNotCondition());
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)column2.getCondition()));
        TemplateColumn column3 = (TemplateColumn)columns.get(2);
        Assert.assertEquals((Object)"ColumnCondition", (Object)column3.getName());
        Assert.assertFalse((boolean)column3.isNotCondition());
        Assert.assertEquals((Object)"== \"test\"", (Object)column3.getCondition());
        TemplateColumn column4 = (TemplateColumn)columns.get(3);
        Assert.assertEquals((Object)"NotColumnCondition", (Object)column4.getName());
        Assert.assertTrue((boolean)column4.isNotCondition());
        Assert.assertEquals((Object)"== \"test2\"", (Object)column4.getCondition());
    }
}

