/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.objects;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.drools.template.DataProvider;
import org.drools.template.parser.Column;
import org.drools.template.parser.TemplateContainer;

public class ObjectDataProvider
implements DataProvider {
    private Column[] columns;
    private Iterator<?> iter;

    public ObjectDataProvider(TemplateContainer tcont, Collection<?> objs) {
        this.columns = tcont.getColumns();
        this.iter = objs.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    private Method getMethod(Class<?> clazz, String field) {
        String Field2 = Character.toUpperCase(field.charAt(0)) + field.substring(1);
        Object getter = "get" + Field2;
        try {
            return clazz.getMethod((String)getter, new Class[0]);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            getter = "is" + Field2;
            try {
                return clazz.getMethod((String)getter, new Class[0]);
            }
            catch (SecurityException e2) {
                return null;
            }
            catch (NoSuchMethodException e2) {
                getter = field;
                try {
                    return clazz.getMethod((String)getter, new Class[0]);
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    private Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getField(field);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] nextFromMap(Object obj) {
        Map map = (Map)obj;
        String[] values = new String[this.columns.length];
        for (int iCol = 0; iCol < this.columns.length; ++iCol) {
            Object target = map.get(this.columns[iCol].getName());
            values[iCol] = target == null ? null : target.toString();
        }
        return values;
    }

    private String[] nextFromObject(Object obj) {
        Class<?> clazz = obj.getClass();
        String[] values = new String[this.columns.length];
        for (int iCol = 0; iCol < this.columns.length; ++iCol) {
            String fieldName = this.columns[iCol].getName();
            Object val = null;
            try {
                Method method = this.getMethod(clazz, fieldName);
                if (method != null) {
                    val = method.invoke(obj, new Object[0]);
                } else {
                    Field field = this.getField(clazz, fieldName);
                    if (field != null) {
                        val = field.get(obj);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            values[iCol] = val == null ? null : val.toString();
        }
        return values;
    }

    @Override
    public String[] next() {
        Object obj = this.iter.next();
        if (obj instanceof Map) {
            return this.nextFromMap(obj);
        }
        return this.nextFromObject(obj);
    }
}

