/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.template.parser.Column;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.util.StringUtils;
import org.junit.Test;

public class RuleTemplateTest {
    @Test
    public void testSetContents() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.setContents("Test template");
        Assertions.assertThat((String)rt.getContents()).isEqualTo("Test template\n");
    }

    private TemplateContainer getTemplateContainer() {
        return new TemplateContainer(){

            public Column getColumn(String name) {
                return null;
            }

            public Column[] getColumns() {
                return null;
            }

            public String getHeader() {
                return null;
            }

            public Map<String, RuleTemplate> getTemplates() {
                return null;
            }
        };
    }

    @Test
    public void testAddColumn() {
        RuleTemplate rt = new RuleTemplate("rt1", this.getTemplateContainer());
        rt.addColumn("StandardColumn");
        rt.addColumn("!NotColumn");
        rt.addColumn("ColumnCondition == \"test\"");
        rt.addColumn("!NotColumnCondition == \"test2\"");
        rt.addColumn("ArrayColumnCondition[0] == \"test2\"");
        List columns = rt.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(5);
        TemplateColumn column1 = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column1.getName()).isEqualTo("StandardColumn");
        Assertions.assertThat((boolean)column1.isNotCondition()).isFalse();
        Assertions.assertThat((boolean)StringUtils.isEmpty((CharSequence)column1.getCondition())).isTrue();
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        Assertions.assertThat((String)column2.getName()).isEqualTo("NotColumn");
        Assertions.assertThat((boolean)column2.isNotCondition()).isTrue();
        Assertions.assertThat((boolean)StringUtils.isEmpty((CharSequence)column2.getCondition())).isTrue();
        TemplateColumn column3 = (TemplateColumn)columns.get(2);
        Assertions.assertThat((String)column3.getName()).isEqualTo("ColumnCondition");
        Assertions.assertThat((boolean)column3.isNotCondition()).isFalse();
        Assertions.assertThat((String)column3.getCondition()).isEqualTo("== \"test\"");
        TemplateColumn column4 = (TemplateColumn)columns.get(3);
        Assertions.assertThat((String)column4.getName()).isEqualTo("NotColumnCondition");
        Assertions.assertThat((boolean)column4.isNotCondition()).isTrue();
        Assertions.assertThat((String)column4.getCondition()).isEqualTo("== \"test2\"");
    }
}

