/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import org.assertj.core.api.Assertions;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.junit.Test;

public class PackageRenderTest {
    public Rule buildRule() {
        Rule rule = new Rule("myrule", new Integer(42), 1);
        rule.setComment("rule comments");
        Condition cond = new Condition();
        cond.setComment("cond comment");
        cond.setSnippet("cond snippet");
        rule.addCondition(cond);
        Consequence cons = new Consequence();
        cons.setComment("cons comment");
        cons.setSnippet("cons snippet");
        rule.addConsequence(cons);
        return rule;
    }

    @Test
    public void testRulesetRender() {
        Package ruleSet = new Package("my ruleset");
        ruleSet.addFunctions("my functions");
        ruleSet.addRule(this.buildRule());
        Rule rule = this.buildRule();
        rule.setName("other rule");
        ruleSet.addRule(rule);
        Import imp = new Import();
        imp.setClassName("clazz name");
        imp.setComment("import comment");
        ruleSet.addImport(imp);
        DRLOutput out = new DRLOutput();
        ruleSet.renderDRL(out);
        String drl = out.getDRL();
        Assertions.assertThat((String)drl).isNotNull();
        System.out.println(drl);
        Assertions.assertThat((drl.indexOf("rule \"myrule\"") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("salience 42") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("//rule comments") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("my functions") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("package my_ruleset;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("rule \"other rule\"") > drl.indexOf("rule \"myrule\"") ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testRulesetAttribute() {
        Package ruleSet = new Package("my ruleset");
        ruleSet.setAgendaGroup("agroup");
        ruleSet.setNoLoop(true);
        ruleSet.setSalience(Integer.valueOf(100));
        DRLOutput out = new DRLOutput();
        ruleSet.renderDRL(out);
        String drl = out.getDRL();
        Assertions.assertThat((boolean)drl.contains("agenda-group \"agroup\"")).isTrue();
        Assertions.assertThat((boolean)drl.contains("no-loop true")).isTrue();
        Assertions.assertThat((boolean)drl.contains("salience 100")).isTrue();
    }
}

