/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.template.parser.Column;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.junit.Test;

public class DefaultTemplateContainerTest {
    @Test
    public void testParseTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_simple.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("package This_is_a_ruleset;\n");
        Assertions.assertThat((int)t.getColumns().length).isEqualTo(1);
        Assertions.assertThat((String)t.getColumns()[0].getName()).isEqualTo("name");
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("name");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplateNoPackage() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_no_package.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("");
        Assertions.assertThat((int)t.getColumns().length).isEqualTo(1);
        Assertions.assertThat((String)t.getColumns()[0].getName()).isEqualTo("name");
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("name");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"Rule_@{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplateNoPackageWithImport() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_no_package_with_import.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("import org.drools.template.jdbc.Person;\n");
        Assertions.assertThat((int)t.getColumns().length).isEqualTo(1);
        Assertions.assertThat((String)t.getColumns()[0].getName()).isEqualTo("name");
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("name");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"Rule_@{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplatePackageWithImport() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_package_with_import.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("package This_is_a_ruleset;\nimport org.drools.template.jdbc.Person;\n");
        Assertions.assertThat((int)t.getColumns().length).isEqualTo(1);
        Assertions.assertThat((String)t.getColumns()[0].getName()).isEqualTo("name");
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("name");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"Rule_@{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplateIndentedKeywords() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/rule_template_indented.drl");
        new DefaultTemplateContainer(is);
    }

    @Test
    public void testParseTemplateWithKeywordVariableNames() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_with_keyword_variable_names.drl");
        new DefaultTemplateContainer(is);
    }

    @Test
    public void testParseTemplateConditions() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_conditions.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("package This_is_a_ruleset;\n");
        Assertions.assertThat((int)t.getColumns().length).isEqualTo(1);
        Assertions.assertThat((String)t.getColumns()[0].getName()).isEqualTo("name");
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(1);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn templateColumn = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)templateColumn.getName()).isEqualTo("name");
        Assertions.assertThat((String)templateColumn.getCondition()).isEqualTo("== \"name1\"");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"How cool is @{name} @{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplateNoHeader() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid1.drl");
            new DefaultTemplateContainer(is);
            Assertions.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assertions.assertThat((String)expected.getMessage()).isEqualTo("Missing header");
        }
    }

    @Test
    public void testParseTemplateNoHeaderColumns() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid2.drl");
            new DefaultTemplateContainer(is);
            Assertions.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assertions.assertThat((String)expected.getMessage()).isEqualTo("Missing header columns");
        }
    }

    @Test
    public void testParseTemplateNoTemplates() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid3.drl");
            new DefaultTemplateContainer(is);
            Assertions.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assertions.assertThat((String)expected.getMessage()).isEqualTo("Missing templates");
        }
    }

    @Test
    public void testParseTemplateNoEndTemplate() {
        try {
            InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_invalid4.drl");
            new DefaultTemplateContainer(is);
            Assertions.fail((String)"DecisionTableParseException expected");
        }
        catch (DecisionTableParseException expected) {
            Assertions.assertThat((String)expected.getMessage()).isEqualTo("Missing end template");
        }
    }

    @Test
    public void testNullInputStream() {
        try {
            new DefaultTemplateContainer((InputStream)null);
            Assertions.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidTemplatePath() {
        try {
            new DefaultTemplateContainer("invalid path");
            Assertions.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testParseComplexTemplate() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_complex.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Assertions.assertThat((String)t.getHeader()).isEqualTo("package This_is_a_ruleset;\n");
        Column[] columnList = t.getColumns();
        Assertions.assertThat((int)columnList.length).isEqualTo(5);
        Assertions.assertThat((String)columnList[0].getName()).isEqualTo("first_name");
        Assertions.assertThat((String)columnList[1].getName()).isEqualTo("last_name");
        Assertions.assertThat((String)columnList[2].getName()).isEqualTo("age");
        Assertions.assertThat((String)columnList[3].getName()).isEqualTo("city");
        Assertions.assertThat((String)columnList[4].getName()).isEqualTo("phone");
        Assertions.assertThat((Object)t.getColumn("last_name")).isEqualTo((Object)columnList[1]);
        Map templates = t.getTemplates();
        Assertions.assertThat((int)templates.size()).isEqualTo(2);
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        Assertions.assertThat((Object)template).isNotNull();
        List columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(1);
        TemplateColumn column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("first_name");
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"How cool is @{first_name} @{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
        template = (RuleTemplate)templates.get("template2");
        Assertions.assertThat((Object)template).isNotNull();
        columns = template.getColumns();
        Assertions.assertThat((int)columns.size()).isEqualTo(2);
        column = (TemplateColumn)columns.get(0);
        Assertions.assertThat((String)column.getName()).isEqualTo("first_name");
        TemplateColumn column2 = (TemplateColumn)columns.get(1);
        Assertions.assertThat((String)column2.getName()).isEqualTo("last_name");
        contents = template.getContents();
        Assertions.assertThat((boolean)contents.startsWith("rule \"How uncool is @{first_name} @{row.rowNumber}\"")).isTrue();
        Assertions.assertThat((boolean)contents.endsWith("then\nend\n")).isTrue();
    }

    @Test
    public void testParseTemplateWithComments() {
        InputStream is = DefaultTemplateContainerTest.class.getResourceAsStream("/templates/test_template_with_comment.drl");
        DefaultTemplateContainer t = new DefaultTemplateContainer(is);
        Map templates = t.getTemplates();
        RuleTemplate template = (RuleTemplate)templates.get("template1");
        List columns = template.getColumns();
        TemplateColumn templateColumn = (TemplateColumn)columns.get(0);
        String contents = template.getContents();
        Assertions.assertThat((boolean)contents.contains("@{name}")).isTrue();
        Assertions.assertThat((boolean)contents.contains("@{invalidName}")).isFalse();
    }
}

