/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import org.assertj.core.api.Assertions;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Rule;
import org.junit.Test;

public class RuleRenderTest {
    @Test
    public void testRuleRender() {
        Rule rule = new Rule("myrule", Integer.valueOf(42), 1);
        rule.setComment("rule comments");
        Condition cond = new Condition();
        cond.setComment("cond comment");
        cond.setSnippet("cond snippet");
        rule.addCondition(cond);
        Consequence cons = new Consequence();
        cons.setComment("cons comment");
        cons.setSnippet("cons snippet;");
        rule.addConsequence(cons);
        rule.addConsequence(cons);
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String drl = out.getDRL();
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("cond snippet") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("cons snippet") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("salience 42") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("salience 42") < drl.indexOf("when") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("cond snippet") < drl.indexOf("then") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("cons snippet;") > drl.indexOf("then") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("rule") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("end") > drl.indexOf("rule ") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("//rule comments") > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testAttributes() throws Exception {
        Rule rule = new Rule("la", Integer.valueOf(42), 2);
        rule.setActivationGroup("foo");
        rule.setNoLoop(true);
        rule.setRuleFlowGroup("ruleflowgroup");
        rule.setDuration(Long.valueOf(42L));
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String result = out.toString();
        Assertions.assertThat((result.indexOf("ruleflow-group \"ruleflowgroup\"") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((result.indexOf("no-loop true") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((result.indexOf("activation-group \"foo\"") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((result.indexOf("duration 42") > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testMetadata() throws Exception {
        Rule rule = new Rule("la", Integer.valueOf(42), 2);
        rule.addMetadata("Author( A. U. Thor )");
        rule.addMetadata("Revision( 42 )");
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String result = out.toString();
        Assertions.assertThat((boolean)result.contains("@Author( A. U. Thor )")).isTrue();
        Assertions.assertThat((boolean)result.contains("@Revision( 42 )")).isTrue();
    }

    @Test
    public void testNotEscapeChars() {
        Condition cond = new Condition();
        cond.setSnippet("a < b");
        DRLOutput out = new DRLOutput();
        cond.renderDRL(out);
        Assertions.assertThat((out.toString().indexOf("a < b") != -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testNilSalience() {
        Rule rule = new Rule("MyRule", null, 1);
        DRLOutput out = new DRLOutput();
        rule.renderDRL(out);
        String xml = out.toString();
        int idx = xml.indexOf("salience");
        Assertions.assertThat((int)idx).isEqualTo(-1);
        rule = new Rule("MyRule", Integer.valueOf(42), 1);
        out = new DRLOutput();
        rule.renderDRL(out);
        xml = out.toString();
        idx = xml.indexOf("salience");
        Assertions.assertThat((idx > -1 ? 1 : 0) != 0).isTrue();
    }
}

