/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import org.drools.template.parser.AbstractColumn;
import org.drools.template.parser.ArrayCell;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;
import org.drools.util.StringUtils;

public class ArrayColumn
extends AbstractColumn {
    private Column type;

    public ArrayColumn(String n, Column typeColumn) {
        super(n);
        this.type = typeColumn;
    }

    @Override
    public Cell createCell(Row row) {
        return new ArrayCell(row, this);
    }

    @Override
    public String getCellType() {
        return this.type.getCellType();
    }

    public Column getType() {
        return this.type;
    }

    @Override
    public String getCondition(String condition, int index) {
        if (index == -1) {
            StringBuilder conditionString = new StringBuilder("ArrayCell(row == r, column == $param");
            if (!StringUtils.isEmpty((CharSequence)condition)) {
                conditionString.append(", value ").append(condition);
            }
            conditionString.append(")");
            return conditionString.toString();
        }
        return this.type.getCondition(condition, index);
    }
}

