/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.template.parser.Column;
import org.drools.template.parser.Generator;
import org.drools.template.parser.Row;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.StringColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.template.parser.TemplateDataListener;
import org.junit.Before;
import org.junit.Test;

public class ExternalSheetListenerTest {
    private TemplateDataListener esl;
    private List<Row> assertedRows = new ArrayList<Row>();

    @Before
    public void setUp() throws Exception {
        this.esl = new TemplateDataListener(2, 2, (TemplateContainer)new TestTemplateContainer(), (Generator)new TestGenerator());
    }

    @Test
    public void testRenderDrl() {
        String drl = this.esl.renderDRL();
        Assertions.assertThat((String)drl).isEqualTo("Test Template Header\nTest Generated DRL\n");
    }

    @Test
    public void testRowHandling() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.finishSheet();
        Assertions.assertThat((int)this.assertedRows.size()).isEqualTo(2);
    }

    @Test
    public void testRowHandlingBlankRows() {
        this.esl.newRow(0, 3);
        this.esl.newCell(0, 0, "row0col0", 0);
        this.esl.newCell(0, 1, "row0col1", 0);
        this.esl.newCell(0, 2, "row0col2", 0);
        this.esl.newRow(1, 3);
        this.esl.newCell(1, 0, "row1col0", 0);
        this.esl.newCell(1, 1, "row1col1", 0);
        this.esl.newCell(1, 2, "row1col2", 0);
        this.esl.newRow(2, 3);
        this.esl.newCell(2, 0, "row2col0", 0);
        this.esl.newCell(2, 1, "row2col1", 0);
        this.esl.newCell(2, 2, "row2col2", 0);
        this.esl.newRow(3, 3);
        this.esl.newCell(3, 0, "", 0);
        this.esl.newCell(3, 1, "", 0);
        this.esl.newCell(3, 2, "", 0);
        this.esl.newRow(4, 3);
        this.esl.newCell(4, 0, "", 0);
        this.esl.newCell(4, 1, "", 0);
        this.esl.newCell(4, 2, "", 0);
        this.esl.finishSheet();
        Assertions.assertThat((int)this.assertedRows.size()).isEqualTo(2);
    }

    private class TestTemplateContainer
    implements TemplateContainer {
        private TestTemplateContainer() {
        }

        public void addColumn(Column c) {
        }

        public void addTemplate(RuleTemplate template) {
        }

        public Column[] getColumns() {
            return new Column[]{new StringColumn("Pattern 1"), new StringColumn("Pattern 2"), new StringColumn("Pattern 3")};
        }

        public String getHeader() {
            return "Test Template Header";
        }

        public Map<String, RuleTemplate> getTemplates() {
            return Map.of("template", new RuleTemplate("template", (TemplateContainer)this));
        }

        public void setHeader(String head) {
        }

        public void setTemplates(Map<String, RuleTemplate> templates) {
        }

        public Column getColumn(String name) {
            return null;
        }
    }

    private class TestGenerator
    implements Generator {
        private TestGenerator() {
        }

        public void generate(String templateName, Row row) {
            ExternalSheetListenerTest.this.assertedRows.add(row);
        }

        public String getDrl() {
            return "Test Generated DRL";
        }
    }
}

