/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.agenda;

import org.drools.core.common.ActivationsManager;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.agenda.TruthMaintenanceSystemAgendaItem;
import org.drools.tms.beliefsystem.ModedAssertion;

public class TruthMaintenanceSystemAgendaItemImpl<T extends ModedAssertion<T>>
extends RuleAgendaItem
implements TruthMaintenanceSystemAgendaItem<T> {
    private LinkedList<LogicalDependency<T>> justified;
    private LinkedList<LogicalDependency<SimpleMode>> blocked;
    private LinkedList<SimpleMode> blockers;

    public TruthMaintenanceSystemAgendaItemImpl() {
    }

    public TruthMaintenanceSystemAgendaItemImpl(long activationNumber, Tuple tuple, int salience, PropagationContext context, PathMemory pmem, TerminalNode rtn, boolean declarativeAgendaEnabled, InternalAgendaGroup agendaGroup) {
        super(activationNumber, tuple, salience, context, pmem, rtn, declarativeAgendaEnabled, agendaGroup);
    }

    @Override
    public void addBlocked(LogicalDependency<SimpleMode> dep) {
        if (this.blocked == null) {
            this.blocked = new LinkedList();
        }
        this.blocked.add(dep);
        TruthMaintenanceSystemAgendaItemImpl blocked = (TruthMaintenanceSystemAgendaItemImpl)dep.getJustified();
        if (blocked.blockers == null) {
            blocked.blockers = new LinkedList();
            blocked.blockers.add((LinkedListNode)dep.getMode());
        } else if (dep.getMode().getNext() == null && dep.getMode().getPrevious() == null && blocked.getBlockers().getFirst() != dep.getMode()) {
            blocked.blockers.add((LinkedListNode)dep.getMode());
        }
    }

    @Override
    public void removeAllBlockersAndBlocked(ActivationsManager activationsManager) {
        if (this.blockers != null) {
            for (LinkedListEntry node = (LinkedListEntry)this.blockers.getFirst(); node != null; node = (LinkedListEntry)node.getNext()) {
                LogicalDependency dep = (LogicalDependency)node.getObject();
                dep.getJustifier().getBlocked().remove((LinkedListNode)dep);
            }
        }
        this.blockers = null;
        if (this.blocked != null) {
            LogicalDependency dep = (LogicalDependency)this.blocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.removeBlocked(dep);
                TruthMaintenanceSystemAgendaItemImpl justified = (TruthMaintenanceSystemAgendaItemImpl)dep.getJustified();
                if (justified.getBlockers().isEmpty()) {
                    activationsManager.stageLeftTuple(null, (AgendaItem)justified);
                }
                dep = tmp;
            }
        }
        this.blocked = null;
    }

    @Override
    public void removeBlocked(LogicalDependency<SimpleMode> dep) {
        this.blocked.remove(dep);
        TruthMaintenanceSystemAgendaItemImpl blocked = (TruthMaintenanceSystemAgendaItemImpl)dep.getJustified();
        blocked.blockers.remove((LinkedListNode)dep.getMode());
    }

    @Override
    public LinkedList<LogicalDependency<SimpleMode>> getBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(LinkedList<LogicalDependency<SimpleMode>> justified) {
        this.blocked = justified;
    }

    @Override
    public LinkedList<SimpleMode> getBlockers() {
        return this.blockers;
    }

    @Override
    public void addLogicalDependency(LogicalDependency<T> node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList<LogicalDependency<T>> getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList<LogicalDependency<T>> justified) {
        this.justified = justified;
    }
}

