/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.tms.TMSMockInternalMatch;
import org.junit.Before;
import org.junit.Test;

public class LazyTMSEnablingTest {
    private StatefulKnowledgeSessionImpl ksession;
    private TruthMaintenanceSystem tms;

    @Before
    public void setUp() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        this.tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession);
    }

    @Test
    public void shouldLazilyAdd() throws Exception {
        String fact1 = "logical";
        this.ksession.insert((Object)"logical");
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.tms.getEqualityKeysSize()).as("Shouldn't have anything, since no logical insert was performed.", new Object[0])).isEqualTo(0);
        String fact2 = "logical";
        TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession).insert((Object)"logical", null, (InternalMatch)new TMSMockInternalMatch());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.tms.getEqualityKeysSize()).as("Now that a logical insert was done, it should have an element.", new Object[0])).isEqualTo(1);
        ObjectTypeConf typeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"logical");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)typeConf.isTMSEnabled()).as("Should have enabled TMS", new Object[0])).isTrue();
    }

    @Test
    public void shouldEnableTMSForSpecificType() throws Exception {
        String stringFact1 = "toto";
        String stringFact2 = "toto";
        String anotherString = "tata";
        Integer intFact1 = 99;
        Integer intFact2 = 99;
        Double doubleFact = 77.8;
        ObjectTypeConf stringTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)"toto");
        ObjectTypeConf intTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.ksession.getEntryPoint(), (Object)intFact1);
        this.ksession.insert((Object)"toto");
        this.ksession.insert((Object)"tata");
        this.ksession.insert((Object)intFact1);
        this.ksession.insert((Object)doubleFact);
        for (ObjectTypeConf conf : this.ksession.getObjectTypeConfigurationRegistry().values()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)conf.isTMSEnabled()).as("TMS shouldn't be enabled for any type, since no logical insert was done.", new Object[0])).isFalse();
        }
        TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.ksession);
        tms.insert((Object)"toto", null, (InternalMatch)new TMSMockInternalMatch());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)stringTypeConf.isTMSEnabled()).as("Should have enabled TMS for Strings.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intTypeConf.isTMSEnabled()).as("Shouldn't have enabled TMS for Integers.", new Object[0])).isFalse();
        tms.insert((Object)intFact2, null, (InternalMatch)new TMSMockInternalMatch());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intTypeConf.isTMSEnabled()).as("Now it should have enabled TMS for Integers!.", new Object[0])).isTrue();
    }
}

