/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.beliefsystem.defeasible;

import java.util.Arrays;
import java.util.List;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedListNode;
import org.drools.tms.LogicalDependency;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.ModedAssertion;
import org.drools.tms.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.tms.beliefsystem.defeasible.DefeasibleMode;
import org.drools.tms.beliefsystem.defeasible.DefeasibleRuleNature;
import org.drools.tms.beliefsystem.defeasible.Defeats;
import org.drools.tms.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.tms.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.tms.beliefsystem.jtms.JTMSMode;
import org.kie.api.runtime.rule.FactHandle;

public class DefeasibleBeliefSet<M extends DefeasibleMode<M>>
implements JTMSBeliefSet<M> {
    private BeliefSystem beliefSystem;
    public static final String DEFEATS = Defeats.class.getSimpleName();
    private static final FastIterator iterator = new IteratorImpl();
    private InternalFactHandle rootHandle;
    private M rootUndefeated;
    private M tailUndefeated;
    private int definitelyPosCount;
    private int definitelyNegCount;
    private int defeasiblyPosCount;
    private int defeasiblyNegCount;
    private int defeatedlyPosCount;
    private int defeatedlyNegCount;
    private static final int DEFINITELY_POS_BIT = 1;
    private static final int DEFINITELY_NEG_BIT = 2;
    private static final int DEFEASIBLY_POS_BIT = 4;
    private static final int DEFEASIBLY_NEG_BIT = 8;
    private static final int DEFEATEDLY_POS_BIT = 16;
    private static final int DEFEATEDLY_NEG_BIT = 32;
    private static final int POS_MASK = 21;
    private static final int NEG_MASK = 42;
    private static final int WEAK_POS_MASK = 20;
    private static final int WEAK_NEG_MASK = 40;
    private int statusMask = 0;
    private DefeasibilityStatus status;

    public DefeasibleBeliefSet(BeliefSystem<M> beliefSystem, InternalFactHandle rootHandle) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    @Override
    public BeliefSystem<M> getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    @Override
    public M getFirst() {
        return this.rootUndefeated;
    }

    @Override
    public M getLast() {
        return this.tailUndefeated;
    }

    @Override
    public void add(M newDep) {
        ((DefeasibleMode)newDep).setStatus(this.resolveStatus((DefeasibleMode)newDep));
        RuleImpl rule = ((JTMSMode)newDep).getLogicalDependency().getJustifier().getRule();
        boolean wasDefeated = false;
        for (Object existingDep = this.rootUndefeated; existingDep != null; existingDep = (DefeasibleMode)existingDep.getNext()) {
            wasDefeated = this.checkIsDefeated((DefeasibleMode)newDep, rule, (DefeasibleMode)existingDep);
            if (!wasDefeated) continue;
            ((DefeasibleMode)existingDep).addDefeated(newDep);
            break;
        }
        if (!wasDefeated) {
            M stagedDeps = null;
            Object existingDep = this.rootUndefeated;
            while (existingDep != null) {
                DefeasibleMode next = (DefeasibleMode)existingDep.getNext();
                if (this.checkIsDefeated((DefeasibleMode)existingDep, ((JTMSMode)existingDep).getLogicalDependency().getJustifier().getRule(), (DefeasibleMode)newDep)) {
                    this.removeUndefeated((DefeasibleMode)existingDep);
                    ((DefeasibleMode)newDep).addDefeated(existingDep);
                    if (((DefeasibleMode)existingDep).getRootDefeated() != null) {
                        if (stagedDeps == null) {
                            stagedDeps = ((DefeasibleMode)existingDep).getRootDefeated();
                        } else {
                            stagedDeps.setPrevious(((DefeasibleMode)existingDep).getTailDefeated());
                            stagedDeps = ((DefeasibleMode)existingDep).getRootDefeated();
                        }
                    }
                    ((DefeasibleMode)existingDep).clearDefeated();
                }
                existingDep = next;
            }
            this.addUndefeated(newDep);
            this.reprocessDefeated(stagedDeps);
        }
        this.updateStatus();
    }

    private void reprocessDefeated(M deps) {
        Object dep = deps;
        while (dep != null) {
            DefeasibleMode next = (DefeasibleMode)dep.getNext();
            dep.nullPrevNext();
            this.add(dep);
            dep = next;
        }
    }

    @Override
    public void remove(M dep) {
        if (((DefeasibleMode)dep).getDefeatedBy() != null) {
            M defeater = ((DefeasibleMode)dep).getDefeatedBy();
            ((DefeasibleMode)defeater).removeDefeated(dep);
        } else {
            this.removeUndefeated((DefeasibleMode)dep);
            if (((DefeasibleMode)dep).getRootDefeated() != null) {
                this.reprocessDefeated(((DefeasibleMode)dep).getRootDefeated());
            }
        }
        this.updateStatus();
    }

    private boolean checkIsDefeated(DefeasibleMode potentialInferior, RuleImpl rule, DefeasibleMode potentialSuperior) {
        if (potentialSuperior.getDefeats() == null) {
            return false;
        }
        if (potentialSuperior.getStatus() == DefeasibilityStatus.DEFINITELY && potentialInferior.getStatus() != DefeasibilityStatus.DEFINITELY) {
            return true;
        }
        return (Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getName()) >= 0 || Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getPackage() + "." + rule.getName()) >= 0) && "neg".equals(potentialSuperior.getValue()) ^ "neg".equals(potentialInferior.getValue());
    }

    public void addUndefeated(M dep) {
        boolean pos = ((JTMSMode)dep).getValue() == null || !JTMSBeliefSetImpl.MODE.NEGATIVE.getId().equals(((JTMSMode)dep).getValue());
        switch (((DefeasibleMode)dep).getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    ++this.definitelyPosCount;
                    this.statusMask |= 1;
                    break;
                }
                ++this.definitelyNegCount;
                this.statusMask |= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    ++this.defeasiblyPosCount;
                    this.statusMask |= 4;
                    break;
                }
                ++this.defeasiblyNegCount;
                this.statusMask |= 8;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    ++this.defeatedlyPosCount;
                    this.statusMask |= 0x10;
                    break;
                }
                ++this.defeatedlyNegCount;
                this.statusMask |= 0x20;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == null) {
            this.rootUndefeated = dep;
            this.tailUndefeated = dep;
        } else if (((DefeasibleMode)dep).getStatus() == DefeasibilityStatus.DEFINITELY) {
            this.rootUndefeated.setPrevious(dep);
            dep.setNext(this.rootUndefeated);
            this.rootUndefeated = dep;
        } else {
            this.tailUndefeated.setNext(dep);
            dep.setPrevious(this.tailUndefeated);
            this.tailUndefeated = dep;
        }
    }

    public void removeUndefeated(DefeasibleMode dep) {
        boolean pos = dep.getValue() == null || !JTMSBeliefSetImpl.MODE.NEGATIVE.getId().equals(dep.getValue());
        switch (dep.getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    --this.definitelyPosCount;
                    if (this.definitelyPosCount != 0) break;
                    this.statusMask ^= 1;
                    break;
                }
                --this.definitelyNegCount;
                if (this.definitelyNegCount != 0) break;
                this.statusMask ^= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    --this.defeasiblyPosCount;
                    if (this.defeasiblyPosCount != 0) break;
                    this.statusMask ^= 4;
                    break;
                }
                --this.defeasiblyNegCount;
                if (this.defeasiblyNegCount != 0) break;
                this.statusMask ^= 8;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    --this.defeatedlyPosCount;
                    if (this.defeatedlyPosCount != 0) break;
                    this.statusMask ^= 0x10;
                    break;
                }
                --this.defeatedlyNegCount;
                if (this.defeatedlyNegCount != 0) break;
                this.statusMask ^= 0x20;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == dep) {
            this.removeFirst();
        } else if (this.tailUndefeated == dep) {
            this.removeLast();
        } else {
            dep.getPrevious().setNext((Entry)dep.getNext());
            dep.getNext().setPrevious(dep.getPrevious());
            dep.nullPrevNext();
        }
    }

    public M removeFirst() {
        if (this.rootUndefeated == null) {
            return null;
        }
        M dep = this.rootUndefeated;
        this.rootUndefeated = (DefeasibleMode)dep.getNext();
        dep.setNext(null);
        if (this.rootUndefeated != null) {
            this.rootUndefeated.setPrevious(null);
        } else {
            this.tailUndefeated = null;
        }
        return dep;
    }

    public M removeLast() {
        if (this.tailUndefeated == null) {
            return null;
        }
        M dep = this.tailUndefeated;
        this.tailUndefeated = (DefeasibleMode)dep.getPrevious();
        dep.setPrevious(null);
        if (this.tailUndefeated != null) {
            this.tailUndefeated.setNext(null);
        } else {
            this.rootUndefeated = this.tailUndefeated;
        }
        return dep;
    }

    public LinkedListNode getRootUndefeated() {
        return this.rootUndefeated;
    }

    public LinkedListNode getTailUnDefeated() {
        return this.tailUndefeated;
    }

    @Override
    public boolean isEmpty() {
        return this.rootUndefeated == null;
    }

    @Override
    public int size() {
        return this.definitelyPosCount + this.definitelyNegCount + this.defeasiblyPosCount + this.defeasiblyNegCount + this.defeatedlyPosCount + this.defeatedlyNegCount;
    }

    public int undefeatdSize() {
        int i = 0;
        for (Object existingNode = this.rootUndefeated; existingNode != null; existingNode = (DefeasibleMode)existingNode.getNext()) {
            ++i;
        }
        return i;
    }

    @Override
    public void cancel(PropagationContext propagationContext) {
        FastIterator<M> it = this.iterator();
        ModedAssertion node = this.getFirst();
        while (node != this.tailUndefeated) {
            DefeasibleMode temp = (DefeasibleMode)it.next((Object)node);
            LogicalDependency dep = ((JTMSMode)node).getLogicalDependency();
            dep.getJustifier().getLogicalDependencies().remove(dep);
            this.remove((M)node);
            node = temp;
        }
        node = this.getFirst();
        LogicalDependency dep = ((JTMSMode)node).getLogicalDependency();
        dep.getJustifier().getLogicalDependencies().remove(dep);
    }

    @Override
    public void clear(PropagationContext propagationContext) {
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isDefinitelyPosProveable() {
        return (this.statusMask & 1) != 0;
    }

    public boolean isDefinitelyNegProveable() {
        return (this.statusMask & 2) != 0;
    }

    public boolean isDefeasiblyPosProveable() {
        return (this.statusMask & 4) != 0;
    }

    public boolean isDefeasiblyNegProveable() {
        return (this.statusMask & 8) != 0;
    }

    public boolean isDefeatedlyPosProveable() {
        return (this.statusMask & 0x10) != 0;
    }

    public boolean isDefeatedlyNegProveable() {
        return (this.statusMask & 0x20) != 0;
    }

    public DefeasibilityStatus getStatus() {
        return this.status;
    }

    public void updateStatus() {
        if (this.isDefinitelyPosProveable() ^ this.isDefinitelyNegProveable()) {
            this.status = DefeasibilityStatus.DEFINITELY;
            return;
        }
        if (this.isConflicting()) {
            this.status = DefeasibilityStatus.UNDECIDABLY;
            return;
        }
        if (this.isDefeasiblyPosProveable() ^ this.isDefeasiblyNegProveable()) {
            this.status = DefeasibilityStatus.DEFEASIBLY;
            return;
        }
        if (this.isDefeatedlyPosProveable() ^ this.isDefeatedlyNegProveable()) {
            this.status = DefeasibilityStatus.DEFEATEDLY;
            return;
        }
        this.status = DefeasibilityStatus.UNDECIDABLY;
    }

    @Override
    public boolean isNegated() {
        return (this.statusMask & 0x15) == 0 && (this.statusMask & 0x2A) != 0;
    }

    @Override
    public boolean isPositive() {
        return (this.statusMask & 0x15) != 0 && (this.statusMask & 0x2A) == 0;
    }

    @Override
    public boolean isConflicting() {
        return (this.statusMask & 0x15) != 0 && (this.statusMask & 0x2A) != 0;
    }

    @Override
    public boolean isDecided() {
        return this.getStatus() != DefeasibilityStatus.UNDECIDABLY && this.getStatus() != DefeasibilityStatus.DEFEATEDLY;
    }

    @Override
    public FastIterator<M> iterator() {
        return iterator;
    }

    private DefeasibilityStatus resolveStatus(DefeasibleMode node) {
        List premise = node.getLogicalDependency().getJustifier().getFactHandles();
        DefeasibilityStatus status = DefeasibilityStatus.resolve(node.getValue());
        if (status == null) {
            DefeasibleRuleNature defeasibleType = DefeasibleRuleNature.STRICT;
            if (node.getLogicalDependency().getJustifier().getRule().getMetaData().containsKey(DefeasibleRuleNature.DEFEASIBLE.getLabel())) {
                defeasibleType = DefeasibleRuleNature.DEFEASIBLE;
            } else if (node.getLogicalDependency().getJustifier().getRule().getMetaData().containsKey(DefeasibleRuleNature.DEFEATER.getLabel())) {
                defeasibleType = DefeasibleRuleNature.DEFEATER;
            }
            switch (defeasibleType) {
                case DEFEASIBLE: {
                    status = this.checkDefeasible(premise);
                    break;
                }
                case DEFEATER: {
                    status = this.checkDefeater(premise);
                    break;
                }
                default: {
                    status = this.checkStrict(premise);
                }
            }
        }
        return status;
    }

    private DefeasibilityStatus checkDefeasible(List<? extends FactHandle> premise) {
        return DefeasibilityStatus.DEFEASIBLY;
    }

    private DefeasibilityStatus checkDefeater(List<? extends FactHandle> premise) {
        return DefeasibilityStatus.DEFEATEDLY;
    }

    private DefeasibilityStatus checkStrict(List<? extends FactHandle> premise) {
        for (FactHandle factHandle : premise) {
            DefeasibleBeliefSet bs;
            if (factHandle instanceof QueryElementFactHandle) {
                return DefeasibilityStatus.DEFINITELY;
            }
            EqualityKey key = ((InternalFactHandle)factHandle).getEqualityKey();
            if (key == null || key.getStatus() != 2 || (bs = (DefeasibleBeliefSet)((TruthMaintenanceSystemEqualityKey)key).getBeliefSet()).getStatus() == DefeasibilityStatus.DEFINITELY) continue;
            return DefeasibilityStatus.DEFEASIBLY;
        }
        return DefeasibilityStatus.DEFINITELY;
    }

    private static class IteratorImpl<M extends DefeasibleMode<M>>
    implements FastIterator<M> {
        private IteratorImpl() {
        }

        public M next(M dep) {
            if (((DefeasibleMode)dep).getRootDefeated() != null) {
                return ((DefeasibleMode)dep).getRootDefeated();
            }
            if (dep.getNext() != null) {
                return (M)((DefeasibleMode)dep.getNext());
            }
            if (((DefeasibleMode)dep).getDefeatedBy() != null) {
                return (M)((DefeasibleMode)((DefeasibleMode)dep).getDefeatedBy().getNext());
            }
            return null;
        }

        public boolean isFullIterator() {
            return true;
        }
    }
}

