/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.util.ArrayList;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.TraitableMap;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraitMapCoreTest
extends CommonTraitTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraitMapCoreTest.class);

    @Test(timeout=10000L)
    public void testMapCoreManyTraits() {
        String source = "package org.drools.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Traitable;\nglobal List list;\n \ndeclare HashMap @Traitable end \n\nglobal List list; \n\ndeclare trait PersonMap\n@propertyReactive  \n   name : String  \n   age  : int  \n   height : Double  \nend\n\ndeclare trait StudentMap\n@propertyReactive\n   ID : String\n   GPA : Double = 3.0\nend\n\nrule Don  \nno-loop \nwhen  \n  $m : Map( this[ \"age\"] == 18 )\nthen  \n   Object obj1 = don( $m, PersonMap.class );\n   Object obj2 = don( obj1, StudentMap.class );\n\nend\n\n";
        KieSession ks = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "john");
        map.put("age", 18);
        ks.insert(map);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(map.get("GPA")).isEqualTo((Object)3.0);
    }

    @Test(timeout=10000L)
    public void donMapTest() {
        String source = "package org.drools.traits.test; \nimport java.util.*\n;import org.drools.base.factmodel.traits.Traitable;\nglobal List list; \ndeclare HashMap @Traitable end \ndeclare trait PersonMap@propertyReactive \n   name : String \n   age  : int \n   height : Double \nend\nrule Don \nwhen \n  $m : Map( this[ \"age\"] == 18 ) then \n   don( $m, PersonMap.class );\nend \nrule Log \nwhen \n   $p : PersonMap( name == \"john\", age > 10 ) \nthen \n   modify ( $p ) { \n       setHeight( 184.0 ); \n   }end \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "john");
        map.put("age", 18);
        ksession.insert(map);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)map.containsKey("height")).isTrue();
        Assertions.assertThat((double)184.0).isEqualTo(map.get("height"));
    }

    @Test(timeout=10000L)
    public void testMapCore2() {
        String source = "package org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Traitable;\nglobal List list;\n declare HashMap @Traitable end \n\n\nglobal List list; \n\ndeclare trait PersonMap\n@propertyReactive  \n   name : String  \n   age  : int  \n   height : Double  \nend\n\ndeclare trait StudentMap\n@propertyReactive\n   ID : String\n   GPA : Double = 3.0\nend\n\nrule Don  \nwhen  \n  $m : Map( this[ \"age\"] == 18, this[ \"ID\" ] != \"100\" )\nthen  \n   don( $m, PersonMap.class );\n\nend\n\nrule Log  \nwhen  \n   $p : PersonMap( name == \"john\", age > 10 )\nthen  \n   modify ( $p ) {  \n       setHeight( 184.0 );  \n   }\nend\nrule Don2\nsalience -1\nwhen\n   $m : Map( this[ \"age\"] == 18, this[ \"ID\" ] != \"100\" ) then\n   don( $m, StudentMap.class );\nend\nrule Log2\nsalience -2\nno-loop\nwhen\n   $p : StudentMap( $h : fields[ \"height\" ], GPA >= 3.0 ) then\n   modify ( $p ) {\n       setGPA( 4.0 ),\n       setID( \"100\" );\n   }\nend\n\nrule Shed1\nsalience -5// it seams that the order of shed must be the same as applying don\nwhen\n    $m : PersonMap()\nthen\n   shed( $m, PersonMap.class );\nend\n\nrule Shed2\nsalience -9\nwhen\n    $m : StudentMap()\nthen\n   shed( $m, StudentMap.class );\nend\nrule Last  \nsalience -99 \nwhen  \n  $m : Map( this not isA StudentMap.class )\nthen  \n   $m.put( \"final\", true );\nend\n";
        KieSession ks = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "john");
        map.put("age", 18);
        ks.insert(map);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(map.get("ID")).isEqualTo((Object)"100");
        Assertions.assertThat(map.get("height")).isEqualTo((Object)184.0);
        Assertions.assertThat(map.get("GPA")).isEqualTo((Object)4.0);
        Assertions.assertThat(map.get("final")).isEqualTo((Object)true);
    }

    @Test(timeout=10000L)
    public void testMapCoreAliasing() {
        String source = "package org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.*;\nglobal List list;\n declare HashMap @Traitable() end \n\nglobal List list; \n\ndeclare trait PersonMap\n@propertyReactive  \n   name : String  \n   age  : Integer  @Alias( \"years\" ) \n   eta  : Integer  @Alias( \"years\" ) \n   height : Double  @Alias( \"tall\" ) \n   sen : String @Alias(\"years\") \n end\n\nrule Don  \nwhen  \n  $m : Map()\nthen  \n   don( $m, PersonMap.class );\n\nend\n\nrule Log  \nwhen  \n   $p : PersonMap( name == \"john\", age > 10 && < 35 )\nthen  \n   modify ( $p ) {  \n       setHeight( 184.0 ), \n       setEta( 42 );  \n   }\nend\n";
        KieSession ks = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "john");
        map.put("years", new Integer(18));
        ks.insert(map);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(map.get("years")).isEqualTo((Object)42);
        Assertions.assertThat(map.get("tall")).isEqualTo((Object)184.0);
    }

    @Test(timeout=10000L)
    public void testMapCoreAliasingLogicalTrueWithTypeClash() {
        String source = "package org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.*;\nglobal List list;\n declare HashMap @Traitable( logical = true ) end \n\nglobal List list; \n\ndeclare trait PersonMap\n@propertyReactive  \n   name : String  \n   age  : Integer  @Alias( \"years\" ) \n   eta  : Integer  @Alias( \"years\" ) \n   height : Double  @Alias( \"tall\" ) \n   sen : String @Alias(\"years\") \n end\n\nrule Don  \nwhen  \n  $m : Map()\nthen  \n  PersonMap pm = don( $m, PersonMap.class ); \n  list.add ( pm ); \n\nend\n\n\n";
        KieSession ks = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ks.getKieBase());
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "john");
        map.put("years", new Integer(18));
        ks.insert(map);
        ks.fireAllRules();
        Assertions.assertThat((list.size() == 1 && list.get(0) == null ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testDrools216() {
        String drl = "\n\npackage org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Alias\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable(logical=true) end \n\ndeclare trait Citizen\n@traitable\n    citizenship : String = \"Unknown\"\nend\n\ndeclare trait Student extends Citizen\n@propertyReactive\n   ID : String = \"412314\" @Alias(\"personID\")\n   GPA : Double = 3.99\nend\n\ndeclare Person\n@Traitable\n    personID : String\n    isStudent : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    hasBenefits : Boolean = true\nend\n\n\nrule \"1\"\nsalience 1\nno-loop\nwhen\nthen\n    Person p = new Person(\"1020\",true);\n    Map map = new HashMap();\n    map.put(\"isEmpty\",true);\n    insert(p);\n    insert(map);\n    list.add(\"initialized\");\nend\n\nrule \"2\"\nsalience 1\nno-loop\nwhen\n    $stu : Person(isStudent == true)\n    $map : Map(this[\"isEmpty\"] == true)\nthen\n    Student s = don( $stu , Student.class );\n    $map.put(\"worker\" , s);\n    $map.put(\"isEmpty\" , false);\n    update($map);\n    list.add(\"student is donned\");\nend\n\nrule \"3\"\nsalience 1\nno-loop\nwhen\n    $map : Map($stu : this[\"worker\"] isA Student.class)\nthen\n    Object obj = don( $map , Worker.class );\n    list.add(\"worker is donned\");\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("initialized")).isTrue();
        Assertions.assertThat((boolean)list.contains("student is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("worker is donned")).isTrue();
    }

    @Test
    public void testDrools217() {
        String drl = "\npackage org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Alias\n\nglobal java.util.List list;\ndeclare HashMap @Traitable(logical=true) end \n\ndeclare trait Citizen\n@traitable\n    citizenship : String = \"Unknown\"\nend\n\ndeclare trait Student extends Citizen\n@propertyReactive\n   ID : String = \"412314\" @Alias(\"personID\")\n   GPA : Double = 3.99\nend\n\ndeclare Person\n@Traitable\n    personID : String\n    isStudent : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    hasBenefits : Boolean = true\nend\n\n\nrule \"1\"\nsalience 1\nno-loop\nwhen\nthen\n    Person p = new Person(\"1020\",true);\n    Map map = new HashMap();\n    map.put(\"isEmpty\",true);\n    insert(p);\n    insert(map);\n    list.add(\"initialized\");\nend\n\nrule \"2\"\nsalience 1\nno-loop\nwhen\n    $stu : Person(isStudent == true)\n    $map : Map(this[\"isEmpty\"] == true)\nthen\n    Student s = don( $stu , Student.class );\n    $map.put(\"worker\" , s);\n    $map.put(\"isEmpty\" , false);\n    update($map);\n    list.add(\"student is donned\");\nend\n\nrule \"3\"\nsalience 1\nno-loop\nwhen\n    $map : Map($stu : this[\"worker\"], $stu isA Student.class)\nthen\n    Object obj = don( $map , Worker.class );\n    list.add(\"worker is donned\");\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("initialized")).isTrue();
        Assertions.assertThat((boolean)list.contains("student is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("worker is donned")).isTrue();
    }

    @Test
    public void testDrools218() {
        String drl = "\npackage org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Alias\n\nglobal java.util.List list;\n\ndeclare trait Citizen\n@traitable\n    citizenship : String = \"Unknown\"\nend\n\ndeclare HashMap @Traitable(logical=true) end \ndeclare trait Student extends Citizen\n@propertyReactive\n   ID : String = \"412314\" @Alias(\"personID\")\n   GPA : Double = 3.99\nend\n\ndeclare Person\n@Traitable\n    personID : String\n    isStudent : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    //customer : Citizen\n    hasBenefits : Boolean = true\nend\n\ndeclare trait StudentWorker extends Worker\n@propertyReactive\n    //currentStudent : Citizen @Alias(\"customer\")\n    tuitionWaiver : Boolean @Alias(\"hasBenefits\")\nend\n\nrule \"1\"\nsalience 1\nno-loop\nwhen\nthen\n    Person p = new Person(\"1020\",true);\n    Map map = new HashMap();\n    map.put(\"isEmpty\",true);\n    insert(p);\n    insert(map);\n    list.add(\"initialized\");\nend\n\nrule \"2\"\nsalience 1\nno-loop\nwhen\n    $stu : Person(isStudent == true)\n    $map : Map(this[\"isEmpty\"] == true)\nthen\n    Student s = don( $stu , Student.class );\n    $map.put(\"worker\" , s);\n    $map.put(\"isEmpty\" , false);\n    $map.put(\"hasBenefits\",null);\n    update($map);\n    list.add(\"student is donned\");\nend\n\nrule \"3\"\nsalience 1\nno-loop\nwhen\n    $map : Map($stu : this[\"worker\"])\n    Map($stu isA Student.class, this == $map)\nthen\n    Object obj = don( $map , Worker.class );\n    list.add(\"worker is donned\");\nend\n\nrule \"4\"\nsalience 1\nno-loop\nwhen\n    $stu : Student()\nthen\n    Object obj = don( $stu , StudentWorker.class );\n    list.add(\"studentworker is donned\");\nend\n\nrule \"5\"\nsalience 1\nno-loop\nwhen\n    StudentWorker(tuitionWaiver == true)\nthen\n    list.add(\"tuitionWaiver is true\");\nend\n\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("initialized")).isTrue();
        Assertions.assertThat((boolean)list.contains("student is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("worker is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("studentworker is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("tuitionWaiver is true")).isTrue();
    }

    @Test
    public void testDrools219() {
        String drl = "\n\npackage org.drools.base.factmodel.traits.test;\n\nimport java.util.*;\nimport org.drools.base.factmodel.traits.Alias\n\nglobal java.util.List list;\n\n\ndeclare trait Citizen\n    citizenship : String = \"Unknown\"\n    socialSecurity : String = \"0\"\nend\n\ndeclare trait Student extends Citizen\n@propertyReactive\n   ID : String = \"412314\" @Alias(\"personID\") \n   GPA : Double = 3.99\n   SSN : String = \"888111155555\" @Alias(\"socialSecurity\")\nend\n\ndeclare Person\n@Traitable(logical=true)\n    personID : String\n    isStudent : boolean\nend\n\nrule \"1\"\nsalience 1\nno-loop\nwhen\nthen\n    Person p = new Person( null, true );\n    insert(p);\n    list.add(\"initialized\");\nend\n\nrule \"2\"\nsalience 1\nno-loop\nwhen\n    $stu : Person(isStudent == true)\nthen\n    Student s = don( $stu , Student.class );\n    list.add(\"student is donned\");\nend\n\nrule \"3\"\nsalience 1\nno-loop\nwhen\n    $stu : Student(ID == \"412314\", SSN == \"888111155555\")\nthen\n    list.add(\"student has ID and SSN\");\nend\n\nrule \"4\"\nsalience 1\nno-loop\nwhen\n    Student(fields[\"personID\"] == \"412314\", fields[\"socialSecurity\"] == \"888111155555\")\nthen\n    list.add(\"student has personID and socialSecurity\");\nend\n\nrule \"5\"\nsalience 1\nno-loop\nwhen\n    $ctz : Citizen(socialSecurity == \"888111155555\")\nthen\n    list.add(\"citizen has socialSecurity\");\nend\n\nrule \"6\"\nsalience 1\nno-loop\nwhen\n    $p : Person(personID == \"412314\")\nthen\n    list.add(\"person has personID\");\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("initialized")).isTrue();
        Assertions.assertThat((boolean)list.contains("student is donned")).isTrue();
        Assertions.assertThat((boolean)list.contains("student has ID and SSN")).isTrue();
        Assertions.assertThat((boolean)list.contains("student has personID and socialSecurity")).isTrue();
        Assertions.assertThat((boolean)list.contains("citizen has socialSecurity")).isTrue();
        Assertions.assertThat((boolean)list.contains("person has personID")).isTrue();
    }

    @Test
    public void testMapTraitsMismatchTypes() {
        String drl = "package org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare org.drools.factmodel.MapCore\n@Traitable( logical = true )\nend\ndeclare HashMap @Traitable( logical = true ) end \n\n\ndeclare trait ParentTrait\n@propertyReactive\n    name : String\n    id : int\nend\n\ndeclare trait ChildTrait\n@propertyReactive\n    naam : String\n    id : float \nend\n\nrule \"don1\"\nno-loop\nwhen\n    $map : Map()\nthen\n    ParentTrait pt = don( $map , ParentTrait.class );\n    ChildTrait ct = don( $map , ChildTrait.class );\n    list.add( pt );\n    list.add( ct );\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "hulu");
        map.put("id", Float.valueOf(3.4f));
        ksession.insert(map);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list.get(0)).isNull();
        Assertions.assertThat(list.get(1)).isNotNull();
    }

    @Test
    public void testMapTraitNoType() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable end \n\ndeclare trait ChildTrait\n@propertyReactive\n    naam : String = \"kudak\"\n    id : int = 1020\nend\n\nrule \"don\"\nno-loop\nwhen\n    $map : Map()then\n    don( $map , ChildTrait.class );\n    list.add(\"correct1\");\nend\n\nrule \"check\"\nno-loop\nwhen\n    $c : ChildTrait($n : naam == \"kudak\", id == 1020 )\n    $p : Map( this[\"naam\"] == $n )\nthen\n    list.add(\"correct2\");\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap map = new HashMap();
        ksession.insert(map);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("correct1")).isTrue();
        Assertions.assertThat((boolean)list.contains("correct2")).isTrue();
    }

    @Test(timeout=10000L)
    public void testMapTraitMismatchTypes() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable( logical = true ) end \n\n\ndeclare trait ChildTrait\n@Trait( logical = true )@propertyReactive\n    naam : String = \"kudak\"\n    id : int = 1020\nend\n\nrule \"don\"\nno-loop\nwhen\n    $map : Map()then\n    ChildTrait ct = don( $map , ChildTrait.class );\n    list.add( ct );\nend\n\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("naam", new Integer(12));
        ksession.insert(map);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo(null);
    }

    @Test
    public void testMapTraitPossibilities1() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable( logical = true ) end \n\ndeclare ESM @Traitable( logical = true )\n val : String\nend\n\ndeclare trait TName\n//@Trait( logical = true )\n length : Integer\nend\n\ndeclare trait ChildTrait\n//@Trait( logical = true )\n@propertyReactive\n name : ESM\n id : int = 1002\nend\n\nrule \"init\"\nno-loop\nwhen\nthen\n Map map = new HashMap();\n ESM esm = new ESM(\"ali\");\n TName tname = don( esm , TName.class );\n map.put(\"name\",tname);\n insert(map);\nend\n\n\nrule \"don\"\nno-loop\nwhen\n $map : Map()then\n ChildTrait ct = don( $map , ChildTrait.class );\n list.add( ct );\nend\n\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isNotNull();
    }

    @Test
    public void testMapTraitPossibilities2() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable( logical = true ) end \n\ndeclare ESM @Traitable( logical = true )\n val : String\nend\n\ndeclare trait TName\n//@Trait( logical = true )\n length : Integer\nend\n\ndeclare trait TEsm extends TName\n//@Trait( logical = true )\n isValid : boolean\nend\n\ndeclare trait ChildTrait\n//@Trait( logical = true )\n@propertyReactive\n name : ESM\n id : int = 1002\nend\n\nrule \"init\"\nno-loop\nwhen\nthen\n Map map = new HashMap();\n ESM esm = new ESM(\"ali\");\n TName tname = don( esm , TName.class );\n TEsm tesm = don( esm , TEsm.class );\n map.put(\"name\",tesm);\n insert(map);\nend\n\n\nrule \"don\"\nno-loop\nwhen\n $map : Map()then\n ChildTrait ct = don( $map , ChildTrait.class );\n list.add( ct );\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isNotNull();
    }

    @Test
    public void testMapTraitPossibilities3() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable( logical = true ) end \n\ndeclare ESM @Traitable( logical = true )\n val : String\nend\n\ndeclare trait TName\n//@Trait( logical = true )\n length : Integer\nend\n\ndeclare trait TEsm extends TName\n//@Trait( logical = true )\n isValid : boolean\nend\n\ndeclare trait ChildTrait\n//@Trait( logical = true )\n@propertyReactive\n name : TName\n id : int = 1002\nend\n\nrule \"init\"\nno-loop\nwhen\nthen\n Map map = new HashMap();\n ESM esm = new ESM(\"ali\");\n TName tname = don( esm , TName.class );\n TEsm tesm = don( esm , TEsm.class );\n map.put(\"name\",tesm);\n insert(map);\nend\n\n\nrule \"don\"\nno-loop\nwhen\n $map : Map()then\n ChildTrait ct = don( $map , ChildTrait.class );\n list.add( ct );\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isNotNull();
    }

    @Test
    public void testMapTraitPossibilities4() {
        String drl = "package openehr.test;//org.drools.base.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\nimport java.util.*;\n\nglobal java.util.List list;\n\ndeclare HashMap @Traitable( logical = true ) end \n\ndeclare ESM @Traitable( logical = true )\n val : String\nend\n\ndeclare NAAM @Traitable( logical = true )\n val : String\nend\n\ndeclare trait TName\n@Trait( logical = true )\n length : Integer\nend\n\ndeclare trait TEsm //extends TName\n//@Trait( logical = true )\n isValid : boolean\nend\n\ndeclare trait ChildTrait\n//@Trait( logical = true )\n@propertyReactive\n name : TName\n id : int = 1002\nend\n\nrule \"init\"\nno-loop\nwhen\nthen\n Map map = new HashMap();\n ESM esm = new ESM(\"ali\");\n TEsm tesm = don( esm , TEsm.class );\n map.put(\"name\",tesm);\n insert(map);\nend\n\n\nrule \"don\"\nno-loop\nwhen\n $map : Map()then\n ChildTrait ct = don( $map , ChildTrait.class );\n list.add( ct );\nend\n";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isNotNull();
    }

    @Test
    public void donCustomMapTest() {
        String source = "package org.drools.traits.test; \nimport java.util.*\n;import " + DomainMap.class.getCanonicalName() + ";\nglobal List list; \ndeclare trait PersonMap@propertyReactive \n   name : String \n   age  : int \n   height : Double \nend\nrule Don \nwhen \n  $m : Map( this[ \"age\"] == 18 ) then \n   don( $m, PersonMap.class );\nend \nrule Log \nwhen \n   $p : PersonMap( name == \"john\", age > 10 ) \nthen \n   modify ( $p ) { \n       setHeight( 184.0 ); \n   }end \n";
        KieSession ksession = this.loadKnowledgeBaseFromString(source).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        DomainMap map = new DomainMap();
        map.put("name", "john");
        map.put("age", 18);
        ksession.insert((Object)map);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)map.containsKey("height")).isTrue();
        Assertions.assertThat((double)184.0).isEqualTo(map.get("height"));
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(DomainMap.class)).size()).isEqualTo(1);
    }

    @Traitable
    public static class DomainMap
    extends HashMap<String, Object>
    implements TraitableMap {
    }
}

