/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.DrlParser;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.traits.core.base.evaluators.IsAEvaluatorDefinition;
import org.junit.jupiter.api.BeforeAll;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class CommonTraitTest {
    @BeforeAll
    public static void beforeClass() {
        System.setProperty("drools.evaluator.isA", IsAEvaluatorDefinition.class.getName());
    }

    protected KieBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drl : drlContentStrings) {
            drl = CommonTraitTest.replaceCustomOperatorIfRequired(drl);
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected KieBase loadKnowledgeBaseFromDrlFile(String drlFilePath) {
        KieBase kieBase;
        block8: {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(drlFilePath);
            try {
                String drl = CommonTraitTest.replaceCustomOperatorIfRequired(new String(is.readAllBytes(), StandardCharsets.UTF_8));
                kieBase = this.loadKnowledgeBaseFromString(drl);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return kieBase;
    }

    protected KieBase loadKnowledgeBaseWithKnowledgeBuilderOption(String drl, KnowledgeBuilderOption ... knowledgeBuilderOptions) {
        drl = CommonTraitTest.replaceCustomOperatorIfRequired(drl);
        return new KieHelper(knowledgeBuilderOptions).addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
    }

    protected KieBase loadKnowledgeBaseWithKieBaseOption(String drl, KieBaseOption ... kieBaseOption) {
        drl = CommonTraitTest.replaceCustomOperatorIfRequired(drl);
        return new KieHelper().addContent(drl, ResourceType.DRL).build(kieBaseOption);
    }

    protected static String replaceCustomOperatorIfRequired(String drl) {
        if (DrlParser.ANTLR4_PARSER_ENABLED) {
            return drl.replaceAll(" isA ", " ##isA ");
        }
        return drl;
    }
}

