/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.base.factmodel.traits.CoreWrapper;
import org.drools.base.factmodel.traits.TraitField;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.InternalRuleBase;
import org.drools.serialization.protobuf.SerializationHelper;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalTraitTest
extends CommonTraitTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicalTraitTest.class);

    public static Stream<VirtualPropertyMode> parameters() {
        return Stream.of(VirtualPropertyMode.MAP, VirtualPropertyMode.TRIPLES);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAlias(VirtualPropertyMode mode) throws Exception {
        KieBase kbase = this.loadKnowledgeBaseFromDrlFile("org/drools/compiler/factmodel/traits/testTraitedAliasing.drl");
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).doesNotContain(new Object[]{Boolean.FALSE});
        Assertions.assertThat(list).hasSize(8);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAliasTraitOnClass(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X \n  fld : T \nend \ndeclare Y \n@Traitable( logical = true ) \n  fld : K \nend \ndeclare trait T @Trait( logical=true ) end \ndeclare K @Traitable() end \nrule Don \nwhen \nthen \n  Y y = new Y( new K() ); \n  don( y, X.class ); \nend \nrule Check \nwhen \n  X( fld isA T ) \nthen \n  list.add( \"ok\" );end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"ok"});
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAliasClassOnTrait(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X \n  fld : K \nend \ndeclare Y \n@Traitable( logical = true ) \n  fld : T \nend \ndeclare trait T @Trait( logical=true ) end \ndeclare K @Traitable() end \nrule Don \nwhen \nthen \n  K k = new K(); \n  T t = don( k, T.class ); \n  Y y = new Y( t ); \n  don( y, X.class ); \nend \nrule Check \nsalience 1 \nwhen \n  $x : Y( fld isA T ) \nthen \n  list.add( \"ok1\" );end \nrule Check2 \nwhen \n  $x : X( fld isA T ) \nthen \n  list.add( \"ok2\" );end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"ok1", "ok2"});
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAliasTraitOnTrait(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X \n  fld : A \nend \ndeclare Y \n@Traitable( logical = true ) \n  fld : B \nend \ndeclare trait A @Trait( logical=true ) end \ndeclare trait B @Trait( logical=true ) end \ndeclare K @Traitable() end \nrule Don \nwhen \nthen \n  K k = new K(); \n  B b = don( k, B.class ); \n  Y y = new Y( b ); \n  don( y, X.class ); \nend \nrule Check \nsalience 1 \nwhen \n  $x : Y( fld isA B, fld isA A ) \nthen \n  list.add( \"ok\" ); \nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"ok"});
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void initializationConflictManagement(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nglobal java.util.List list2; \ndeclare trait A name : String = \"1\" age : Integer = 18 end \ndeclare trait B name : String = \"5\" age : Integer = 50 end \ndeclare trait C extends A,B name : String = \"7\" age : Integer = 37 end \ndeclare X @Traitable( logical = true ) name : String end \nrule Init \nwhen \nthen \n  X x = new X(); \n  A a = don( x, A.class ); \n      list.add( x.getName() ); \n      list2.add( a.getAge() ); \n  B b = don( x, B.class ); \n      list.add( x.getName() ); \n      list2.add( b.getAge() ); \nend \nrule Later \nno-loop \nwhen \n  $x : X() \nthen \n  $x.setName( \"xyz\" ); \n      list.add( $x.getName() ); \n  C c = don( $x, C.class ); \n      list.add( $x.getName() ); \n      list2.add( c.getAge() ); \n  $x.setName( null ); \n  c.setAge( 99 ); \n      list.add( $x.getName() ); \n      list2.add( c.getAge() ); \n  c.setName( \"aaa\" ); \n  c.setAge( null ); \n      list.add( $x.getName() ); \n      list2.add( c.getAge() ); \nend \n";
        KieBase knowledgeBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)knowledgeBase);
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        ArrayList list = new ArrayList();
        ArrayList list2 = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.setGlobal("list2", list2);
        knowledgeSession.fireAllRules();
        for (Object o : knowledgeSession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug(((Object)list).toString());
        LOGGER.debug(((Object)list2).toString());
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"1", null, "xyz", "xyz", "7", "aaa"});
        Assertions.assertThat(list2).containsExactly((Object[])new Integer[]{18, null, 37, 99, 37});
        try {
            knowledgeSession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)knowledgeSession, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testInitializationConflictManagementPrimitiveTypes(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nglobal java.util.List list2; \ndeclare trait A rate : double = 1.0 age : int = 18 end \ndeclare trait B rate : double = 5.0 age : int = 50 end \ndeclare trait C extends A,B rate : double = 7 age : int = 37 end \ndeclare X @Traitable( logical = true ) rate : double end \nrule Init \nwhen \nthen \n  X x = new X(); \n  A a = don( x, A.class ); \n      list.add( x.getRate() ); \n      list2.add( a.getAge() ); \n  B b = don( x, B.class ); \n      list.add( x.getRate() ); \n      list2.add( b.getAge() ); \nend \nrule Later \nno-loop \nwhen \n  $x : X() \nthen \n  $x.setRate( 16.3 ); \n      list.add( $x.getRate() ); \n  C c = don( $x, C.class ); \n      list.add( $x.getRate() ); \n      list2.add( c.getAge() ); \n  $x.setRate( 0.0 ); \n  c.setAge( 99 ); \n      list.add( $x.getRate() ); \n      list2.add( c.getAge() ); \n  c.setRate( -0.72 ); \n  c.setAge( 0 ); \n      list.add( $x.getRate() ); \n      list2.add( c.getAge() ); \nend \n";
        KieBase knowledgeBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)knowledgeBase);
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        ArrayList list = new ArrayList();
        ArrayList list2 = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.setGlobal("list2", list2);
        knowledgeSession.fireAllRules();
        for (Object o : knowledgeSession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        LOGGER.debug(((Object)list).toString());
        LOGGER.debug(((Object)list2).toString());
        Assertions.assertThat(list).containsExactly((Object[])new Double[]{1.0, 0.0, 16.3, 16.3, 0.0, -0.72});
        Assertions.assertThat(list2).containsExactly((Object[])new Integer[]{18, 0, 37, 99, 0});
        try {
            knowledgeSession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)knowledgeSession, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        knowledgeSession.dispose();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    @Disabled(value="check file ReviseTraitTestWithPRAlwaysCategory.java")
    public void testHardGetSetOnLogicallyTraitedField(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; import " + Qty.class.getCanonicalName() + "; global java.util.List list; declare Obs @Traitable( logical = true ) value : Qty end declare trait TObs @Trait( logical = true ) value : TQty end declare trait TQty @Trait( logical = true ) num : Integer end rule Init when then   Obs o = new Obs( new Qty( 42 ) );   don( o, TObs.class ); end rule Log when   $o : TObs( $val : value.num ) then   list.add( $val ); end rule Change when   $s : String()   $o : TObs() then   delete( $s );   modify( $o ) { getValue().setNum( 99 ); } end ";
        KieBase knowledgeBase = this.loadKnowledgeBaseWithKnowledgeBuilderOption(drl, new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED});
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)knowledgeBase);
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{42});
        knowledgeSession.insert((Object)"x");
        knowledgeSession.fireAllRules();
        Object o = knowledgeSession.getObjects((ObjectFilter)new ClassObjectFilter(Qty.class)).iterator().next();
        Assertions.assertThat((Integer)((Qty)o).getNum()).isEqualTo((Object)99);
        Assertions.assertThat((Object)((CoreWrapper)o)._getFieldTMS().get("num", Integer.class)).isEqualTo((Object)99);
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{42, 99});
        knowledgeSession.dispose();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testFieldTypeDonMap(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nglobal java.util.List list2; \ndeclare trait T   hardShort : short = 1 \n  hardChar : char = 1 \n  hardByte : byte = 1 \n  hardInt : int = 1 \n  hardLong : long = 1 \n  hardFloat : float = 1.0f \n  hardDouble : double = 1.0 \n  hardBoolean : boolean = true \n  hardString : String = \"x\" \n  softShort : short = 1 \n  softChar : char = 1 \n  softByte : byte = 1 \n  softInt : int = 1 \n  softLong : long = 1 \n  softFloat : float = 1.0f \n  softDouble : double = 1.0 \n  softBoolean : boolean = true \n  softString : String = \"x\" \nend \ndeclare X @Traitable( logical = true )   hardShort : short  \n  hardChar : char  \n  hardByte : byte  \n  hardInt : int \n  hardLong : long  \n  hardFloat : float  \n  hardDouble : double  \n  hardBoolean : boolean  \nend \nrule Init \nwhen \nthen \n  X x = new X(); \n  don( x, T.class ); \nend \n";
        KieBase knowledgeBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)knowledgeBase);
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        knowledgeSession.fireAllRules();
        for (Object o : knowledgeSession.getObjects()) {
            LOGGER.debug(o.toString());
        }
        try {
            knowledgeSession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)knowledgeSession, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        knowledgeSession.dispose();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testDataStructs(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nglobal java.util.List list2; \ndeclare trait T \n  hardString : String = \"x\" \n  hardString : String = \"x\" \n  softString : String = \"x\" \n  hardFloat : float = 5.9f \nend \ndeclare X @Traitable( logical = true ) \n  id : int @key \n  hardString : String  = \"a\" \n  hardInt    : int  = 12 \n  hardDouble : double  = 42.0 \n  hardFloat : float  = 2.3f \nend \nrule Init \nwhen \nthen \n  X x = new X( 1 ); \n  x.setHardFloat( 8.42f ); \n  insert( x ); \n      x.setHardDouble( -11.2 ); \n  X x2 = new X( 2, \"b\", 13, 44.0, 16.5f ); \n      x2.setHardInt( -1 ); \n  insert( x2 ); \n  don( x, T.class ); \n  don( x2, T.class ); \nend \n";
        KieBase knowledgeBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)knowledgeBase);
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        knowledgeSession.fireAllRules();
        FactType X = knowledgeBase.getFactType("org.drools.test", "X");
        for (Object o : knowledgeSession.getObjects()) {
            if (X.getFactClass().isInstance(o)) {
                switch ((Integer)X.get(o, "id")) {
                    case 1: {
                        Assertions.assertThat((Object)X.get(o, "hardString")).isEqualTo((Object)"a");
                        Assertions.assertThat((Object)X.get(o, "hardInt")).isEqualTo((Object)12);
                        Assertions.assertThat((Object)X.get(o, "hardDouble")).isEqualTo((Object)-11.2);
                        Assertions.assertThat((Object)X.get(o, "hardFloat")).isEqualTo((Object)Float.valueOf(8.42f));
                        break;
                    }
                    case 2: {
                        Assertions.assertThat((Object)X.get(o, "hardString")).isEqualTo((Object)"b");
                        Assertions.assertThat((Object)X.get(o, "hardInt")).isEqualTo((Object)-1);
                        Assertions.assertThat((Object)X.get(o, "hardDouble")).isEqualTo((Object)44.0);
                        Assertions.assertThat((Object)X.get(o, "hardFloat")).isEqualTo((Object)Float.valueOf(16.5f));
                        break;
                    }
                    default: {
                        Assertions.fail((String)"Unexpected id ");
                    }
                }
            }
            LOGGER.debug(o.toString());
        }
        try {
            knowledgeSession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)knowledgeSession, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        knowledgeSession.dispose();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shadowAliasSelf(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait VIP \n@Trait( logical=true ) \n  friend : VIP \nend \ndeclare Pers \n@Traitable( logical = true ) \n  friend : Pers \nend \nrule Don \nwhen \nthen \n  Pers p = new Pers();   p.setFriend( p ); \n\n  don( p, VIP.class ); \nend \nrule Check \nsalience 1 \nwhen \n  $x : Pers( friend isA VIP ) \nthen \n  list.add( \"ok1\" );end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat(list).isEqualTo(List.of("ok1"));
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void traitOnSet(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait T \n@Trait( logical=true ) \n  fld : S \nend \ndeclare trait U \n@Trait( logical=true ) \n  fld : R \nend \ndeclare trait S \n@Trait( logical=true ) \nend \ndeclare trait R \n@Trait( logical=true ) \nend \ndeclare K \n@propertyReactive \n@Traitable( logical = true ) \n  id : int @key\n  fld : K \nend \nrule Don \nwhen \nthen \n  K k = new K(1);   don( k, T.class ); \n  modify ( k ) { \n    setFld( new K(99) ); \n  } \nend \nrule Check \nsalience 1 \nwhen \n  $x : K( fld isA S, fld not isA R ) \nthen \n  list.add( \"ok1\" );end \nrule Check2 \nsalience 1 \nwhen \n  String() \n  $x : K( fld isA S ) \nthen \n  don( $x, U.class ); \nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        int n = ks.fireAllRules();
        LOGGER.debug("Rules fired " + n);
        LOGGER.debug("------------- ROUND TRIP -------------");
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        ks.insert((Object)"go");
        ks.fireAllRules();
        Assertions.assertThat(list).isEqualTo(List.of("ok1"));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAliasTraitOnClassLogicalRetract(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X \n  fld : T \n  fld2 : Q \nend \ndeclare trait W \n  fld : T \nend \ndeclare trait V \n  fld2 : Q \nend \ndeclare Y \n@Traitable( logical = true ) \n  fld : K \n  fld2 : Object \nend \ndeclare trait T @Trait( logical=true ) end \ndeclare trait Q @Trait( logical=true ) end \ndeclare K @Traitable() end \nrule Don \nwhen \n  $s : String( this == \"go\" ) \nthen \n  K k = new K(); \n  Y y = new Y( k, null ); \n  insert( y ); \n  insert( k ); \n  don( k, Q.class ); \n  don( y, X.class, true ); \n  don( y, W.class ); \n  don( y, V.class ); \nend \nrule Check \nwhen \n  $x : X( this isA V, fld isA T ) \nthen \n  shed( $x, V.class ); \n  list.add( \"ok\" );end \nrule Check2 \nsalience 10 \nwhen \n  String( this == \"go2\" ) \n  Q() \n  not X() not V() then \n  list.add( \"ok2\" );end \nrule Check3 \nsalience 5 \nwhen \n  String( this == \"go2\" ) \n  K( this isA Q ) \n  not X() not V() then \n  list.add( \"ok3\" );end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        FactHandle handle = ks.insert((Object)"go");
        ks.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"ok"});
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o + " >> " + ((InternalFactHandle)ks.getFactHandle(o)).getEqualityKey());
        }
        ks.retract(handle);
        ks.fireAllRules();
        for (Object o : ks.getObjects((ObjectFilter)new ClassObjectFilter(ks.getKieBase().getFactType("org.drools.test", "Y").getFactClass()))) {
            Assertions.assertThat(o).isInstanceOf(TraitableBean.class);
            TraitableBean tb = (TraitableBean)o;
            TraitField fld = tb._getFieldTMS().getRegisteredTraitField("fld");
            Set types = fld.getRangeTypes();
            Assertions.assertThat((Collection)types).hasSize(2);
            TraitField fld2 = tb._getFieldTMS().getRegisteredTraitField("fld2");
            Set types2 = fld2.getRangeTypes();
            Assertions.assertThat((Collection)types2).hasSize(1);
        }
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        ks.setGlobal("list", list);
        ks.insert((Object)"go2");
        ks.fireAllRules();
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).containsExactly((Object[])new String[]{"ok", "ok2", "ok3"});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testShadowAliasClassOnTraitLogicalRetract(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X \n  fld : K \n  fld2 : K \nend \ndeclare trait W \n  fld : Q \nend \ndeclare trait V \n  fld2 : T \nend \ndeclare Y \n@Traitable( logical = true ) \n  fld : T \n  fld2 : Q \nend \ndeclare trait T @Trait( logical=true ) id : int end \ndeclare trait Q @Trait( logical=true ) id : int end \ndeclare K @Traitable() id : int end \nrule Don \nwhen \n  $s : String( this == \"go\" ) \nthen \n  K k1 = new K( 1 ); \n  K k2 = new K( 2 ); \n  T t = don( k1, T.class ); \n  Q q = don( k2, Q.class ); \n  Y y = new Y( t, q ); \n  insert( y ); \n  don( y, X.class, true ); \nend \nrule Check \nwhen \n  String( this == \"go\" ) \n  $x : X( $f1 : fld, $f2 : fld2 ) \nthen \n  list.add( $f1.getId() );  list.add( $f2.getId() );end \nrule Check2\nwhen \n  not String( this == \"go\" ) \n  $x : Y( $f1 : fld, $f2 : fld2 ) \nthen \n  list.add( $f1.getId() );  list.add( $f2.getId() );end \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        FactHandle handle = ks.insert((Object)"go");
        ks.fireAllRules();
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1, 2});
        ks.retract(handle);
        ks.fireAllRules();
        for (Object o : ks.getObjects((ObjectFilter)new ClassObjectFilter(ks.getKieBase().getFactType("org.drools.test", "Y").getFactClass()))) {
            Assertions.assertThat(o).isInstanceOf(TraitableBean.class);
        }
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        LOGGER.debug(((Object)list).toString());
        Assertions.assertThat(list).containsExactly((Object[])new Integer[]{1, 2, 1, 2});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testSerial(VirtualPropertyMode mode) {
        String drl = "package org.drools.test; \nimport org.drools.base.factmodel.traits.*; \nimport org.drools.base.factmodel.traits.Trait; \nglobal java.util.List list; \ndeclare trait X end \ndeclare trait Z end \ndeclare Y \n@Traitable( ) \nend \nrule Don \nwhen \nthen \n  Y y = new Y( ); \n  don( y, X.class ); \n  don( y, Z.class ); \nend \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (InternalRuleBase)((InternalRuleBase)kbase));
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
        try {
            ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
        for (Object o : ks.getObjects()) {
            LOGGER.debug(o.toString());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitMismatchTypes(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.Thing;\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\n\nglobal java.util.List list;\n\n\ndeclare Parent\n@Traitable( logical = true )\n@propertyReactive\n    id : int\nend\n\ndeclare trait ParentTrait\n@Trait( logical = true )@propertyReactive\n    id : float\nend\n\nrule \"init\"\nwhen\nthen\n    Parent p = new Parent(1010);\n    insert( p );\nend\n\nrule \"don\"\nwhen\n    $p : Parent(id > 1000)\nthen\n    Thing t = don( $p , ParentTrait.class );\n    list.add( t );\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).containsNull();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitMismatchTypes2(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.Thing;\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\n\nglobal java.util.List list;\n\n\ndeclare Foo end \ndeclare Bar end \ndeclare Parent\n@Traitable( logical = true )\n@propertyReactive\n    id : Foo\nend\n\ndeclare trait ParentTrait\n@Trait( logical = true )@propertyReactive\n    id : Bar\nend\n\nrule \"init\"\nwhen\nthen\n    Parent p = new Parent(new Foo());\n    insert( p );\nend\n\nrule \"don\"\nwhen\n    $p : Parent(id != null)\nthen\n    Thing t = don( $p , ParentTrait.class );\n    list.add( t );\nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).containsNull();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testTraitMismatchTypes3(VirtualPropertyMode mode) {
        String drl = "package org.drools.base.factmodel.traits.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Alias;\n\nglobal java.util.List list;\n\n\ndeclare Foo end \ndeclare Bar extends Foo end \ndeclare Parent\n@Traitable( logical = true )\n@propertyReactive\n    id : Foo\nend\n\ndeclare trait ParentTrait\n@Trait( logical = true )@propertyReactive\n    id : Bar\nend\n\nrule \"init\"\nwhen\nthen\n    Parent p = new Parent(null);\n    insert( p );\nend\n\nrule \"don\"\nwhen\n    $p : Parent()\nthen\n    ParentTrait pt = don( $p , ParentTrait.class );\n    pt.setId( new Bar() ); \n   list.add( $p.getId() ); \nend";
        KieSession ksession = this.loadKnowledgeBaseFromString(drl).newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        LOGGER.debug("list" + list);
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat((String)list.get(0).getClass().getName()).isEqualTo("org.drools.base.factmodel.traits.test.Bar");
    }

    @Traitable(logical=true)
    public static class Qty {
        private Integer num;

        public Qty(Integer num) {
            this.num = num;
        }

        public Integer getNum() {
            return this.num;
        }

        public void setNum(Integer num) {
            this.num = num;
        }
    }
}

