/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import org.assertj.core.api.Assertions;
import org.drools.base.factmodel.traits.CoreWrapper;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.Trait;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.traits.compiler.factmodel.traits.IPerson;
import org.drools.traits.compiler.factmodel.traits.IStudent;
import org.drools.traits.compiler.factmodel.traits.Imp;
import org.drools.traits.compiler.factmodel.traits.TraitTestUtils;
import org.drools.traits.core.factmodel.Entity;
import org.drools.traits.core.factmodel.LogicalTypeInconsistencyException;
import org.drools.traits.core.util.StandaloneTraitFactory;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneTest.class);
    private StandaloneTraitFactory factory;

    @BeforeEach
    public void init() {
        ProjectClassLoader loader = ProjectClassLoader.createProjectClassLoader();
        this.factory = TraitTestUtils.createStandaloneTraitFactory();
    }

    @Test
    public void testThing() throws LogicalTypeInconsistencyException {
        Entity core = new Entity("x");
        Thing thing = this.factory.don((TraitableBean)core, Thing.class);
        Assertions.assertThat((Object)thing).isNotNull();
    }

    @Test
    public void testHierarchy() throws LogicalTypeInconsistencyException {
        Imp imp = new Imp();
        imp.setName("john doe");
        CoreWrapper core = this.factory.makeTraitable((Object)imp, Imp.class);
        IStudent student = (IStudent)this.factory.don((TraitableBean)core, IStudent.class);
        LOGGER.debug(student.getName());
        LOGGER.debug(student.getSchool());
        Assertions.assertThat((String)student.getName()).isEqualTo("john doe");
        Assertions.assertThat((String)student.getSchool()).isNull();
        IPerson p = (IPerson)this.factory.don((TraitableBean)core, IPerson.class);
        student.setName("alan ford");
        LOGGER.debug(p.getName());
        Assertions.assertThat((String)p.getName()).isEqualTo("alan ford");
    }

    @Test
    public void testLegacy() throws LogicalTypeInconsistencyException {
        Imp imp = new Imp();
        imp.setName("john doe");
        CoreWrapper core = this.factory.makeTraitable((Object)imp, Imp.class);
        IFoo foo = (IFoo)this.factory.don((TraitableBean)core, IFoo.class);
        LOGGER.debug(foo.getName());
        LOGGER.debug("Is foo instance of Thing? : " + (foo instanceof Thing));
        Assertions.assertThat((String)foo.getName()).isEqualTo("john doe");
        Assertions.assertThat((Object)foo).isInstanceOf(Thing.class);
    }

    @Trait
    public static interface IFoo {
        public String getName();

        public void setName(String var1);
    }
}

