/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.compiler.factmodel.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.traits.compiler.CommonTraitTest;
import org.drools.traits.compiler.ReviseTraitTestWithPRAlwaysCategory;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.drools.traits.core.factmodel.VirtualPropertyMode;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class TraitFieldsAndLegacyClassesTest
extends CommonTraitTest {
    public static Collection<VirtualPropertyMode> modes() {
        return List.of(VirtualPropertyMode.MAP, VirtualPropertyMode.TRIPLES);
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate0(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits0;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Thing;\nimport java.util.*\nimport " + Parent.class.getCanonicalName() + ";\nimport " + Child.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : Child\n    age : int = 24\nend\ndeclare Parent\n@Traitable\n@propertyReactive\nend\nrule \"Init\" \n\nwhen\n    \nthen\n   Parent p = new Parent(\"parent\", null);\n   Map map = new HashMap();\n   map.put( \"parent\", ParentTrait.class );\n   insert(p);\n   insert(map);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\n   $map : HashMap([parent] != null)\nthen\n   Object p = don ( $p , (Class) $map.get(\"parent\") );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate1(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable( logical = true ) \n@propertyReactive\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable \n@propertyReactive\n   gender : String = \"male\"\nend\n\nrule \"Init\" \nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\",c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \nsalience -1\nwhen\n    $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"trait child\" \nwhen\n    $c : Child( gender == \"male\" )\nthen\n   ChildTrait c = don ( $c , ChildTrait.class );\nend\n\nrule \"test parent and child traits\" \nwhen\n    $p : ParentTrait( $c : child isA ChildTrait.class )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate2(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits2;\n\nimport org.drools.base.factmodel.traits.Traitable;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait \n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable( logical=true )\n@propertyReactive\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable\n@propertyReactive\n   gender : String = \"male\"\nend\n\nrule \"Init\" \nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", null);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"trait child\" \nwhen\n   $c : Child( gender == \"male\" )\nthen\n   ChildTrait c = don ( $c , ChildTrait.class );\nend\n\nrule \"assign child to parent\" \nwhen\n   $c : Child( gender == \"male\" )\n   $p : Parent( name == \"parent\" )\n   ParentTrait( child not isA ChildTrait.class )\n   ChildTrait()\nthen\n      modify ( $p ) { \n       setChild($c);\n   }\nend\n\nrule \"test parent and child traits\" \nwhen\n    $p : ParentTrait( child isA ChildTrait.class )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        KieSession knowledgeSession = kBase.newKieSession();
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate3(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits3;\n\nimport org.drools.base.factmodel.traits.Traitable;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable( logical = true )\n@propertyReactive\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable\n@propertyReactive\n   gender : String = \"male\"\nend\n\nrule \"Init\" \nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", null);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"trait child\" \nwhen\n   $c : Child( gender == \"male\" )\nthen\n   ChildTrait c = don ( $c , ChildTrait.class );\nend\n\nrule \"assign child to parent\" \nwhen\n   Child( gender == \"male\" )\n   $p : Parent( name == \"parent\" )\n   ParentTrait( child not isA ChildTrait.class )\n   $c : ChildTrait()\nthen\n   $p.setChild((Child)$c.getCore());\n   update($p);\nend\n\nrule \"test parent and child traits\" \nwhen\n    $p : ParentTrait( child isA ChildTrait.class )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @Category(value={ReviseTraitTestWithPRAlwaysCategory.class})
    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate4(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits4;\n\nimport org.drools.base.factmodel.traits.Traitable;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable(logical=true)\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable\n@propertyReactive\n   gender : String = \"male\"\nend\n\nrule \"Init\" \nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait child\" \nwhen\n   $p : Parent( $c := child not isA ChildTrait )\n   $c := Child( gender == \"male\" )\nthen\n   ChildTrait c = don ( $c , ChildTrait.class );\n   modify ( $p ) {}; \nend\n\nrule \"test parent and a child trait\" \nwhen\n    $p : Parent( child isA ChildTrait.class ) \nthen\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseWithKnowledgeBuilderOption(drl, new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED});
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate5(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits5;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@Trait(logical=true) \n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable(logical=true)\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable\n@propertyReactive\n   gender : String = \"male\"\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"test parent and child traits\" \n\nwhen\n    $p : ParentTrait( $c : child isA ChildTrait.class ) \nthen\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate6(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits6;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Thing;\nimport " + Child.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@Trait(logical=true) \n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable(logical=true)\n@propertyReactive\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable(logical=true)\n@propertyReactive\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"Side effect\" \nwhen \n  $p : Parent( child isA ChildTrait ) \nthen \n   list.add(\"correct2\");\nend \nrule \"test parent and child traits\" \n\nwhen\n    $p : ParentTrait( child isA ChildTrait.class )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct", "correct2"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate7(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Trait;\nimport org.drools.base.factmodel.traits.Thing;\nimport " + Child.class.getCanonicalName() + ";\nimport " + Parent.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait  @position(1)\n    age : int = 24 @position(0)\nend\ndeclare trait ChildTrait\n@Trait( logical = true ) \n@propertyReactive\n   name : String = \"child\"\n   gender : String\nend\ndeclare Parent\n@Traitable( logical=true ) \n@propertyReactive\nend\ndeclare Child\n@Traitable( logical=true ) \n@propertyReactive\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent( \"parent\", c );\n   insert(c); insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"test parent and child traits\" \n\nwhen\n   $p : ParentTrait( child isA ChildTrait )\nthen\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate8(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits8;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Thing;\nimport " + Child.class.getCanonicalName() + ";\nimport " + Parent.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : ChildTrait\n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable(logical=true)\n@propertyReactive\nend\ndeclare Child\n@Traitable(logical=true)\n@propertyReactive\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"test parent and child traits\" \n\nwhen\n    $p : ParentTrait( child isA ChildTrait.class )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate9(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits9;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Thing;\nimport " + Child.class.getCanonicalName() + ";\nimport " + Parent.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : Child\n    age : int = 24\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\nend\ndeclare Parent\n@Traitable\n@propertyReactive\nend\ndeclare Child\n@Traitable\n@propertyReactive\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"trait and assign the child\" \n\nwhen\n   $c : Child( gender == \"male\", this not isA ChildTrait )\n   $p : Parent( this isA ParentTrait )\nthen\n   ChildTrait c =  don ( $c , ChildTrait.class );\n   modify($p){\n       setChild((Child)c.getCore());}\nend\n\nrule \"test parent and child traits\" \n\nwhen\n    $p : ParentTrait( child isA ChildTrait.class, child.gender == \"male\" )\nthen\n   //shed ( $p , ParentTrait.class );\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitFieldUpdate10(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Thing;\nimport " + Child.class.getCanonicalName() + ";\nimport " + Parent.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : Child  @position(1)\n    age : int = 24 @position(0)\nend\ndeclare trait ChildTrait\n@propertyReactive\n   name : String = \"child\"\n   gender : String\nend\ndeclare Parent\n@Traitable\n@propertyReactive\nend\ndeclare Child\n@Traitable\n@propertyReactive\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child();\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\nend\n\nrule \"trait parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait p = don ( $p , ParentTrait.class );\nend\n\nrule \"trait and assign the child\" \n\nwhen\n   $c : Child( gender == \"male\", this not isA ChildTrait )\n   $p : Parent( this isA ParentTrait )\nthen\n   ChildTrait c =  don ( $c , ChildTrait.class );\n   modify($p){\n       setChild((Child)c.getCore());}\nend\n\nrule \"test parent and child traits\" salience 10\n\nwhen\n   $c : Child( $gender := gender)\n   $p : ParentTrait( $age, $c; )\nthen\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testTraitTwoParentOneChild(VirtualPropertyMode mode) {
        String drl = "package org.drools.factmodel.traits;\n\nimport org.drools.base.factmodel.traits.Traitable;\nimport org.drools.base.factmodel.traits.Thing;\nglobal java.util.List list;\n\ndeclare trait ParentTrait\n@propertyReactive\n    child : Child  \n    age : int = 24 \nend\n\ndeclare trait GrandParentTrait\n@propertyReactive\n    grandChild : Child \n    age : int = 64 \nend\ndeclare trait FatherTrait extends ParentTrait, GrandParentTrait \n@propertyReactive\n   name : String = \"child\"\n   gender : String\nend\ndeclare Parent\n@Traitable\n@propertyReactive\n   name : String\n   child : Child\nend\ndeclare Child\n@Traitable\n@propertyReactive\n   name : String\n   gender : String = \"male\"\nend\n\nrule \"Init\" \n\nwhen\n    \nthen\n   Child c = new Child(\"C1\",\"male\");\n   Child c2 = new Child(\"C2\",\"male\");\n   Parent p = new Parent(\"parent\", c);\n   insert(c);insert(p);\n   insert(c2);\nend\n\nrule \"trait as father\" \nsalience -1000\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   FatherTrait p = don ( $p , FatherTrait.class );\nend\n\nrule \"trait as parent\" \n\nwhen\n   $p : Parent( name == \"parent\" )\nthen\n   ParentTrait c =  don ( $p , ParentTrait.class );\nend\n\nrule \"trait and assign the grandchild\" \n\nwhen\n   $c : Child( name == \"C1\" )\n   $p : Parent( child == $c )\nthen\n   GrandParentTrait c =  don ( $p , GrandParentTrait.class );\n   modify(c){\n       setGrandChild( $c );}\nend\n\nrule \"test three traits\" \n\nwhen\n   $p : FatherTrait( this isA ParentTrait, this isA GrandParentTrait )\nthen\n   list.add(\"correct\");\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession knowledgeSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat(list).contains((Object[])new String[]{"correct"});
    }

    @ParameterizedTest
    @Disabled
    @MethodSource(value={"modes"})
    public void testTraitWithPositionArgs(VirtualPropertyMode mode) {
        String drl = "package org.drools.traits.test;\n\nimport org.drools.base.factmodel.traits.Traitable;\n\n\nglobal java.util.List list;\n\ndeclare Person\n@Traitable\n@propertyReactive\n    ssn : String\n    pob : String\n    isStudent : boolean\n    hasAssistantship : boolean\nend\n\ndeclare trait Student\n@propertyReactive\n    studyingCountry : String @position(1)\n    hasAssistantship : boolean\nend\n\ndeclare trait Worker\n@propertyReactive\n    pob : String @position(0)\n    workingCountry : String\nend\n\ndeclare trait USCitizen\n@propertyReactive\n    pob : String = \"US\"\nend\n\ndeclare trait ITCitizen\n@propertyReactive\n    pob : String = \"IT\"\nend\n\ndeclare trait IRCitizen\n@propertyReactive\n    pob : String = \"IR\"\nend\n\ndeclare trait StudentWorker extends Student, Worker\n@propertyReactive\n    uniName : String\nend\n\nrule \"init\"\nwhen\nthen\n    Person p = new Person(\"1234\",\"IR\",true,true);\n    insert( p );\n    list.add(\"initialized\");\n\nend\n\nrule \"check for being student\"\nwhen\n    $p : Person( $ssn : ssn, $pob : pob,  isStudent == true )\n    if($pob == \"IR\" ) do[pobIsIR]\nthen\n    Student st = (Student) don( $p , Student.class );\n    modify( st ){\n        setStudyingCountry( \"US\" );\n    }\n    list.add(\"student\");\nthen[pobIsIR]\n    don( $p , IRCitizen.class );\n    list.add(\"IR citizen\");\nend\n\nrule \"check for being US citizen\"\n\nwhen\n    $s : Student( studyingCountry == \"US\" )\nthen\n    don( $s , USCitizen.class );\n    list.add(\"US citizen\");\nend\n\nrule \"check for being worker\"\n\nwhen\n    $p : Student( hasAssistantship == true, $sc : studyingCountry )\nthen\n    Worker wr = (Worker) don( $p , Worker.class );\n    modify( wr ){\n        setWorkingCountry( $sc );\n    }\n    list.add(\"worker\");\nend\n\nrule \"position args 1\"\nwhen\n    Student( $sc : studyingCountry ) @watch( studyingCountry )\n    $w : Worker( $pob , $sc; )\n    USCitizen( )\n    IRCitizen( $pob := pob )\nthen\n    list.add(\"You are working in US as student worker\");\n    StudentWorker sw = (StudentWorker) don( $w, StudentWorker.class );\n    modify(sw){\n        setUniName( \"ASU\" );\n    }\nend\n\nrule \"position args 2\"\nwhen\n    Student( $sc : studyingCountry ) @watch( studyingCountry )\n    $sw : StudentWorker( $pob , $sc; )\n    IRCitizen( $pob := pob )\nthen\n    list.add(\"You are studying and working at ASU\");\nend\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession kSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assertions.assertThat(list).contains((Object[])new String[]{"initialized"});
        Assertions.assertThat(list).contains((Object[])new String[]{"student"});
        Assertions.assertThat(list).contains((Object[])new String[]{"IR citizen"});
        Assertions.assertThat(list).contains((Object[])new String[]{"US citizen"});
        Assertions.assertThat(list).contains((Object[])new String[]{"worker"});
        Assertions.assertThat(list).contains((Object[])new String[]{"You are working in US as student worker"});
        Assertions.assertThat(list).contains((Object[])new String[]{"You are studying and working at ASU"});
    }

    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void singlePositionTraitTest(VirtualPropertyMode mode) {
        String drl = "package org.drools.traits.test;\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\n\ndeclare Pos\n@propertyReactive\n@Traitable\nend\n\ndeclare trait PosTrait\n@propertyReactive\n    field0 : int = 100  //@position(0)\n    field1 : int = 101  //@position(1)\n    field2 : int = 102  //@position(0)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n    mfield0 : int = 200 //@position(0)\n    mfield1 : int = 201 @position(2)\nend\n\n\n";
        KieBase kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        KieSession kSession = kBase.newKieSession();
        FactType parent = kBase.getFactType("org.drools.traits.test", "PosTrait");
        Assertions.assertThat((int)parent.getField("field0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)parent.getField("field1").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)parent.getField("field2").getIndex()).isEqualTo(2);
        FactType child = kBase.getFactType("org.drools.traits.test", "MultiInhPosTrait");
        Assertions.assertThat((int)child.getField("field0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)child.getField("field1").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)child.getField("mfield1").getIndex()).isEqualTo(2);
        Assertions.assertThat((int)child.getField("field2").getIndex()).isEqualTo(3);
        Assertions.assertThat((int)child.getField("mfield0").getIndex()).isEqualTo(4);
        drl = "package org.drools.traits.test;\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\n\ndeclare Pos\n@propertyReactive\n@Traitable\nend\n\ndeclare trait PosTrait\n@propertyReactive\n    field0 : int = 100  //@position(0)\n    field1 : int = 101  //@position(1)\n    field2 : int = 102  @position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n    mfield0 : int = 200 @position(0)\n    mfield1 : int = 201 @position(2)\nend\n\n\n";
        kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        parent = kBase.getFactType("org.drools.traits.test", "PosTrait");
        Assertions.assertThat((int)parent.getField("field0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)parent.getField("field2").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)parent.getField("field1").getIndex()).isEqualTo(2);
        child = kBase.getFactType("org.drools.traits.test", "MultiInhPosTrait");
        Assertions.assertThat((int)child.getField("mfield0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)child.getField("field2").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)child.getField("mfield1").getIndex()).isEqualTo(2);
        Assertions.assertThat((int)child.getField("field0").getIndex()).isEqualTo(3);
        Assertions.assertThat((int)child.getField("field1").getIndex()).isEqualTo(4);
        drl = "package org.drools.traits.test;\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\n\ndeclare Pos\n@propertyReactive\n@Traitable\nend\n\ndeclare trait PosTrait\n@propertyReactive\n    field0 : int = 100  @position(5)\n    field1 : int = 101  @position(0)\n    field2 : int = 102  @position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n    mfield0 : int = 200 @position(0)\n    mfield1 : int = 201 @position(1)\nend\n\n\n";
        kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        parent = kBase.getFactType("org.drools.traits.test", "PosTrait");
        Assertions.assertThat((int)parent.getField("field1").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)parent.getField("field2").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)parent.getField("field0").getIndex()).isEqualTo(2);
        child = kBase.getFactType("org.drools.traits.test", "MultiInhPosTrait");
        Assertions.assertThat((int)child.getField("field1").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)child.getField("mfield0").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)child.getField("field2").getIndex()).isEqualTo(2);
        Assertions.assertThat((int)child.getField("mfield1").getIndex()).isEqualTo(3);
        Assertions.assertThat((int)child.getField("field0").getIndex()).isEqualTo(4);
        drl = "package org.drools.traits.test;\nimport org.drools.base.factmodel.traits.Traitable;\n\nglobal java.util.List list;\n\n\ndeclare Pos\n@propertyReactive\n@Traitable\nend\n\ndeclare trait PosTrait\n@propertyReactive\n    field0 : int = 100  //@position(5)\n    field1 : int = 101  //@position(0)\n    field2 : int = 102  //@position(1)\nend\n\ndeclare trait MultiInhPosTrait extends PosTrait\n@propertyReactive\n    mfield0 : int = 200 //@position(0)\n    mfield1 : int = 201 //@position(1)\nend\n\n\n";
        kBase = this.loadKnowledgeBaseFromString(drl);
        TraitFactoryImpl.setMode((VirtualPropertyMode)mode, (KieBase)kBase);
        parent = kBase.getFactType("org.drools.traits.test", "PosTrait");
        Assertions.assertThat((int)parent.getField("field0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)parent.getField("field1").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)parent.getField("field2").getIndex()).isEqualTo(2);
        child = kBase.getFactType("org.drools.traits.test", "MultiInhPosTrait");
        Assertions.assertThat((int)child.getField("field0").getIndex()).isEqualTo(0);
        Assertions.assertThat((int)child.getField("field1").getIndex()).isEqualTo(1);
        Assertions.assertThat((int)child.getField("field2").getIndex()).isEqualTo(2);
        Assertions.assertThat((int)child.getField("mfield0").getIndex()).isEqualTo(3);
        Assertions.assertThat((int)child.getField("mfield1").getIndex()).isEqualTo(4);
    }

    public static class Parent {
        public String name;
        public Child child;

        public String getName() {
            return this.name;
        }

        public Child getChild() {
            return this.child;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setChild(Child child) {
            this.child = child;
        }

        public Parent(String name, Child child) {
            this.name = name;
            this.child = child;
        }

        public String toString() {
            return "Parent{name='" + this.name + "', child=" + this.child + "}";
        }
    }

    public static class Child {
        private String gender = "male";

        public String getGender() {
            return this.gender;
        }

        public void setGender(String gender) {
            this.gender = gender;
        }

        public String toString() {
            return "Child{gender='" + this.gender + "'}";
        }
    }
}

